/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.hadoop.hive.jdbc.storage.datasource.CarbonDataSourceFetcher;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBManager;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.QueryConstructor;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.Commons;

public class DBOperation {
    private static final Logger log = LoggerFactory.getLogger(DBOperation.class);
    DatabaseProperties dbProperties;
    List<String> fieldNames;
    List<Object> values;
    Map<String, Object> fieldNamesAndValuesMap = new HashMap<String, Object>();
    Connection connection = null;

    public DBOperation(DatabaseProperties databaseProperties, Connection con) {
        this.dbProperties = databaseProperties;
        this.connection = con;
    }

    public DBOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDB(MapWritable map) throws SQLException {
        this.fillFieldNamesAndValueObj(map);
        Statement statement = null;
        try {
            if (!this.dbProperties.isUpdateOnDuplicate()) {
                if (log.isDebugEnabled()) {
                    log.debug("Inserting all data");
                }
                statement = this.insertData((PreparedStatement)statement);
            } else if (this.dbProperties.getDbSpecificUpsertQuery() == null) {
                boolean isRowExisting;
                if (log.isDebugEnabled()) {
                    log.debug("Do the insert and update in DB independent manner.");
                }
                statement = (isRowExisting = this.isRowExisting((PreparedStatement)statement)) ? this.updateData((PreparedStatement)statement) : this.insertData((PreparedStatement)statement);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Do the insert and update using DB specific query.");
                }
                String upsertQuery = this.dbProperties.getDbSpecificUpsertQuery();
                statement = this.connection.prepareStatement(upsertQuery);
                statement = this.setValuesForUpsertStatement((PreparedStatement)statement);
                if (log.isDebugEnabled()) {
                    log.debug("Executing query: " + upsertQuery);
                }
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.error("Failed to write data to database", (Throwable)e);
        }
        finally {
            statement.close();
        }
    }

    private void fillFieldNamesAndValueObj(MapWritable map) {
        this.fieldNames = new ArrayList<String>();
        this.values = new ArrayList<Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (this.dbProperties.getColumnMappingFields() == null) {
                this.fieldNames.add(((Writable)entry.getKey()).toString());
            }
            this.values.add(Commons.getObjectFromWritable((Writable)entry.getValue()));
        }
        if (this.dbProperties.getColumnMappingFields() != null) {
            this.fieldNames.addAll(Arrays.asList(this.dbProperties.getColumnMappingFields()));
        }
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            this.fieldNamesAndValuesMap.put(this.fieldNames.get(i), this.values.get(i));
        }
    }

    private PreparedStatement updateData(PreparedStatement statement) throws SQLException {
        QueryConstructor queryConstructor = new QueryConstructor();
        String sqlQuery = queryConstructor.constructUpdateQuery(this.dbProperties.getTableName(), this.fieldNames, this.dbProperties.getPrimaryFields());
        statement = this.connection.prepareStatement(sqlQuery);
        statement = this.setValuesForUpdateStatement(statement);
        if (log.isDebugEnabled()) {
            log.debug("Executing query: " + sqlQuery);
        }
        statement.executeUpdate();
        return statement;
    }

    private ResultSet selectData(PreparedStatement statement) throws SQLException {
        QueryConstructor queryConstructor = new QueryConstructor();
        String sqlQuery = queryConstructor.constructSelectQuery(this.dbProperties.getTableName(), this.fieldNames, this.dbProperties.getPrimaryFields());
        statement = this.connection.prepareStatement(sqlQuery);
        statement = this.setValuesForWhereClause(statement);
        if (log.isDebugEnabled()) {
            log.debug("Executing query: " + sqlQuery);
        }
        ResultSet resultSet = statement.executeQuery();
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowExisting(PreparedStatement statement) throws SQLException {
        QueryConstructor queryConstructor = new QueryConstructor();
        String sqlQuery = queryConstructor.constructSelectQuery(this.dbProperties.getTableName(), this.fieldNames, this.dbProperties.getPrimaryFields());
        statement = this.connection.prepareStatement(sqlQuery);
        statement = this.setValuesForWhereClause(statement);
        if (log.isDebugEnabled()) {
            log.debug("Executing query: " + sqlQuery);
        }
        ResultSet resultSet = statement.executeQuery();
        boolean isRowExisting = false;
        if (resultSet.next()) {
            isRowExisting = true;
        }
        try {
            resultSet.close();
        }
        finally {
            statement.close();
        }
        return isRowExisting;
    }

    private PreparedStatement insertData(PreparedStatement statement) throws SQLException {
        QueryConstructor queryConstructor = new QueryConstructor();
        String sqlQuery = queryConstructor.constructInsertQuery(this.dbProperties.getTableName(), this.fieldNames.toArray(new String[this.fieldNames.size()]));
        statement = this.connection.prepareStatement(sqlQuery);
        statement = this.setValues(statement);
        if (log.isDebugEnabled()) {
            log.debug("Executing query: " + sqlQuery);
        }
        statement.executeUpdate();
        return statement;
    }

    private PreparedStatement setValuesForUpsertStatement(PreparedStatement statement) {
        String[] valuesOrder = this.dbProperties.getUpsertQueryValuesOrder();
        if (valuesOrder == null) {
            throw new IllegalArgumentException("You must supply both hive.jdbc.upsert.query.values.order and hive.jdbc.output.upsert.query");
        }
        for (int valuesOrderCount = 0; valuesOrderCount < valuesOrder.length; ++valuesOrderCount) {
            Object value = this.fieldNamesAndValuesMap.get(valuesOrder[valuesOrderCount].toLowerCase());
            statement = Commons.assignCorrectObjectType(value, valuesOrderCount + 1, statement);
        }
        return statement;
    }

    private PreparedStatement setValuesForWhereClause(PreparedStatement statement) {
        String[] primaryFields = this.dbProperties.getPrimaryFields();
        if (primaryFields == null || primaryFields.length == 0) {
            primaryFields = new String[]{this.fieldNames.get(0)};
        }
        for (int fieldsCount = 0; fieldsCount < this.fieldNames.size(); ++fieldsCount) {
            for (int primaryFieldsCount = 0; primaryFieldsCount < primaryFields.length; ++primaryFieldsCount) {
                if (!this.fieldNames.get(fieldsCount).equals(primaryFields[primaryFieldsCount])) continue;
                statement = Commons.assignCorrectObjectType(this.values.get(fieldsCount), primaryFieldsCount + 1, statement);
            }
        }
        return statement;
    }

    private PreparedStatement setValuesForUpdateStatement(PreparedStatement statement) {
        String[] primaryKeyFields = this.dbProperties.getPrimaryFields();
        if (primaryKeyFields == null) {
            primaryKeyFields = new String[]{this.fieldNames.get(0)};
        }
        int counter = 0;
        for (int fieldCount = 0; fieldCount < this.fieldNames.size(); ++fieldCount) {
            boolean isPrimaryField = false;
            for (int primaryFieldCount = 0; primaryFieldCount < primaryKeyFields.length; ++primaryFieldCount) {
                if (!this.fieldNames.get(fieldCount).equals(primaryKeyFields[primaryFieldCount])) continue;
                statement = Commons.assignCorrectObjectType(this.values.get(fieldCount), this.fieldNames.size() - (primaryKeyFields.length - primaryFieldCount - 1), statement);
                isPrimaryField = true;
                break;
            }
            if (isPrimaryField) continue;
            statement = Commons.assignCorrectObjectType(this.values.get(fieldCount), ++counter, statement);
        }
        return statement;
    }

    private PreparedStatement setValues(PreparedStatement statement) {
        for (int i = 0; i < this.values.size(); ++i) {
            statement = Commons.assignCorrectObjectType(this.values.get(i), i + 1, statement);
        }
        return statement;
    }

    public boolean isTableExist(String tableName, Connection connection) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "%", null);
        while (tables.next()) {
            if (!tables.getString(3).equalsIgnoreCase(tableName)) continue;
            return true;
        }
        tables.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableIfNotExist(Map<String, String> tableParameters) {
        String inputTable = tableParameters.get("mapred.jdbc.input.table.name");
        String outputTable = tableParameters.get("mapred.jdbc.output.table.name");
        String createTableQuery = tableParameters.get("hive.jdbc.table.create.query");
        if (inputTable == null && (outputTable != null || createTableQuery != null)) {
            DatabaseProperties dbProperties = new DatabaseProperties();
            dbProperties.setTableName(outputTable);
            dbProperties.setUserName(tableParameters.get("mapred.jdbc.username"));
            dbProperties.setPassword(tableParameters.get("mapred.jdbc.password"));
            dbProperties.setConnectionUrl(tableParameters.get("mapred.jdbc.url"));
            dbProperties.setDriverClass(tableParameters.get("mapred.jdbc.driver.class"));
            dbProperties.setDataSourceName(tableParameters.get("wso2.carbon.datasource.name"));
            if (dbProperties.getTableName() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Extracting Table name from sql query");
                }
                dbProperties.setTableName(Commons.extractingTableNameFromQuery(createTableQuery));
            }
            if (dbProperties.getConnectionUrl() == null && dbProperties.getDataSourceName() != null) {
                CarbonDataSourceFetcher carbonDataSourceFetcher = new CarbonDataSourceFetcher();
                Map<String, String> dataSource = carbonDataSourceFetcher.getCarbonDataSource(dbProperties.getDataSourceName());
                dbProperties.setConnectionUrl(dataSource.get("mapred.jdbc.url"));
                dbProperties.setDriverClass(dataSource.get("mapred.jdbc.driver.class"));
                dbProperties.setUserName(dataSource.get("mapred.jdbc.username"));
                dbProperties.setPassword(dataSource.get("mapred.jdbc.password"));
            }
            DBManager dbManager = new DBManager();
            dbManager.createConnection(dbProperties);
            Connection connection = null;
            Statement statement = null;
            try {
                connection = dbManager.getConnection();
                if (!this.isTableExist(dbProperties.getTableName(), connection)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Creating table " + dbProperties.getTableName());
                    }
                    statement = connection.createStatement();
                    statement.executeUpdate(createTableQuery);
                }
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to get connection", (Throwable)e);
            }
            catch (SQLException e) {
                log.error("Failed to create the table " + dbProperties.getTableName(), (Throwable)e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        log.error("Failed to close to statement", (Throwable)e);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        log.error("Failed to close the connection", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCount(String sql, Connection connection) throws SQLException {
        int noOfRows;
        block6: {
            ResultSet resultSet = null;
            PreparedStatement statement = null;
            noOfRows = 0;
            try {
                statement = connection.prepareStatement(sql);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    noOfRows = resultSet.getInt(1);
                    break block6;
                }
                throw new SQLException("Can't get total rows count using sql " + sql);
            }
            catch (SQLException e) {
                log.error("Failed to get total row count", (Throwable)e);
            }
            finally {
                resultSet.close();
                statement.close();
                connection.close();
            }
        }
        return noOfRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQLQueryBeforeDataInsert(Map<String, String> tableParameters) {
        String sqlQueryBeforeDataInsert = tableParameters.get("hive.jdbc.sql.query.before.data.insert");
        if (sqlQueryBeforeDataInsert != null) {
            DatabaseProperties dbProperties = new DatabaseProperties();
            dbProperties.setUserName(tableParameters.get("mapred.jdbc.username"));
            dbProperties.setPassword(tableParameters.get("mapred.jdbc.password"));
            dbProperties.setConnectionUrl(tableParameters.get("mapred.jdbc.url"));
            dbProperties.setDriverClass(tableParameters.get("mapred.jdbc.driver.class"));
            dbProperties.setDataSourceName(tableParameters.get("wso2.carbon.datasource.name"));
            if (dbProperties.getConnectionUrl() == null && dbProperties.getDataSourceName() != null) {
                CarbonDataSourceFetcher carbonDataSourceFetcher = new CarbonDataSourceFetcher();
                Map<String, String> dataSource = carbonDataSourceFetcher.getCarbonDataSource(dbProperties.getDataSourceName());
                dbProperties.setConnectionUrl(dataSource.get("mapred.jdbc.url"));
                dbProperties.setDriverClass(dataSource.get("mapred.jdbc.driver.class"));
                dbProperties.setUserName(dataSource.get("mapred.jdbc.username"));
                dbProperties.setPassword(dataSource.get("mapred.jdbc.password"));
            }
            DBManager dbManager = new DBManager();
            dbManager.createConnection(dbProperties);
            Connection connection = null;
            Statement statement = null;
            try {
                connection = dbManager.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(sqlQueryBeforeDataInsert);
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to get connection", (Throwable)e);
            }
            catch (SQLException e) {
                log.error("Failed to execute the statement " + sqlQueryBeforeDataInsert, (Throwable)e);
            }
            finally {
                try {
                    statement.close();
                    connection.close();
                }
                catch (SQLException e) {
                    log.error("Failed to close the statement/connection ", (Throwable)e);
                }
            }
        }
    }
}

