/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.JDBCDataOutputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.JDBCDataSerDe;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBOperation;
import org.wso2.carbon.hadoop.hive.jdbc.storage.input.JDBCDataInputFormat;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.ConfigurationUtils;

public class JDBCStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return JDBCDataInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return JDBCDataOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return JDBCDataSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties properties = tableDesc.getProperties();
        ConfigurationUtils.copyJDBCProperties(properties, jobProperties);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void preCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        if (!isExternal) {
            throw new MetaException("Tables must be external.");
        }
        Map tableParameters = table.getParameters();
        DBOperation operation = new DBOperation();
        operation.createTableIfNotExist(tableParameters);
    }

    public void rollbackCreateTable(Table table) throws MetaException {
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void preDropTable(Table table) throws MetaException {
        Map tableParameters = table.getParameters();
        DBOperation operation = new DBOperation();
        operation.runSQLQueryBeforeDataInsert(tableParameters);
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean b) throws MetaException {
    }
}

