/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class JDBCDataSerDe
implements SerDe {
    static final String HIVE_TYPE_DOUBLE = "double";
    static final String HIVE_TYPE_FLOAT = "float";
    static final String HIVE_TYPE_BOOLEAN = "boolean";
    static final String HIVE_TYPE_BIGINT = "bigint";
    static final String HIVE_TYPE_TINYINT = "tinyint";
    static final String HIVE_TYPE_SMALLINT = "smallint";
    static final String HIVE_TYPE_INT = "int";
    private final MapWritable cachedWritable = new MapWritable();
    private StructObjectInspector objectInspector;
    private int fieldCount;
    private List<String> columnNames;
    String[] columnTypesArray;
    private List<Object> row;

    public void initialize(Configuration entries, Properties properties) throws SerDeException {
        ArrayList<Object> fieldObjectInspectors;
        String tableColumnNamesString = properties.getProperty("columns");
        if (tableColumnNamesString != null) {
            String[] columnNamesArray = tableColumnNamesString.split(",");
            this.fieldCount = columnNamesArray.length;
            this.columnNames = new ArrayList<String>(columnNamesArray.length);
            this.columnNames.addAll(Arrays.asList(columnNamesArray));
            String columnTypesString = properties.getProperty("columns.types");
            this.columnTypesArray = columnTypesString.split(":");
            fieldObjectInspectors = new ArrayList<Object>(columnNamesArray.length);
            for (int i = 0; i < columnNamesArray.length; ++i) {
                if (HIVE_TYPE_INT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_SMALLINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaShortObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_TINYINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaByteObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_BIGINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_BOOLEAN.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaBooleanObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_FLOAT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaFloatObjectInspector);
                    continue;
                }
                if (HIVE_TYPE_DOUBLE.equalsIgnoreCase(this.columnTypesArray[i])) {
                    fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
                    continue;
                }
                fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
            }
        } else {
            throw new SerDeException("Can't find table column definitions");
        }
        this.objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, fieldObjectInspectors);
        this.row = new ArrayList<Object>(this.columnNames.size());
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector structObjectInspector = (StructObjectInspector)objectInspector;
        List fields = structObjectInspector.getAllStructFieldRefs();
        if (fields.size() != this.columnNames.size()) {
            throw new SerDeException(String.format("Required %d columns, received %d.", this.columnNames.size(), fields.size()));
        }
        this.cachedWritable.clear();
        for (int c = 0; c < this.fieldCount; ++c) {
            StructField structField = (StructField)fields.get(c);
            if (structField == null) continue;
            Object field = structObjectInspector.getStructFieldData(obj, (StructField)fields.get(c));
            AbstractPrimitiveObjectInspector fieldOI = (AbstractPrimitiveObjectInspector)((StructField)fields.get(c)).getFieldObjectInspector();
            Object value = (Writable)fieldOI.getPrimitiveWritableObject(field);
            if (value == null) {
                value = PrimitiveObjectInspector.PrimitiveCategory.STRING.equals((Object)fieldOI.getPrimitiveCategory()) ? NullWritable.get() : new IntWritable(0);
            }
            this.cachedWritable.put((Writable)new Text(this.columnNames.get(c)), value);
        }
        return this.cachedWritable;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        if (!(writable instanceof MapWritable)) {
            throw new SerDeException("Expected MapWritable, received " + writable.getClass().getName());
        }
        MapWritable input = (MapWritable)writable;
        Text t = new Text();
        this.row.clear();
        for (int i = 0; i < this.fieldCount; ++i) {
            t.set(this.columnNames.get(i));
            Writable value = input.get((Object)t);
            if (value != null && !NullWritable.get().equals((Object)value)) {
                if (HIVE_TYPE_INT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()).intValue());
                    continue;
                }
                if (HIVE_TYPE_SMALLINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()).shortValue());
                    continue;
                }
                if (HIVE_TYPE_TINYINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Byte.valueOf(value.toString()));
                    continue;
                }
                if (HIVE_TYPE_BIGINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    Long longValue = value instanceof DoubleWritable ? Long.valueOf(Double.valueOf(value.toString()).longValue()) : (value instanceof IntWritable ? Long.valueOf(Integer.valueOf(value.toString()).longValue()) : Long.valueOf(value.toString()));
                    this.row.add(longValue);
                    continue;
                }
                if (HIVE_TYPE_BOOLEAN.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Boolean.valueOf(value.toString()));
                    continue;
                }
                if (HIVE_TYPE_FLOAT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Float.valueOf(Double.valueOf(value.toString()).floatValue()));
                    continue;
                }
                if (HIVE_TYPE_DOUBLE.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()));
                    continue;
                }
                this.row.add(value.toString());
                continue;
            }
            this.row.add(null);
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

