/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.yarn.demo;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DemoUtils {
    public static final String YARNAPP_JAR_NAME = "YarnApplicationDemo-1.0-SNAPSHOT.jar";
    public static final Path YARNAPP_JAR_PATH = new Path("/apps/yarn/demo/YarnApplicationDemo-1.0-SNAPSHOT.jar");

    public static void setUpEnv(Map<String, String> env, YarnConfiguration conf) {
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$$()).append("<CPS>").append("./*");
        for (String c : conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_CROSS_PLATFORM_APPLICATION_CLASSPATH)) {
            classPathEnv.append("<CPS>");
            classPathEnv.append(c.trim());
        }
        classPathEnv.append("<CPS>").append("./log4j.properties");
        if (conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        env.put("CLASSPATH", classPathEnv.toString());
    }

    public static void setUpLocalResource(Path resPath, LocalResource res, YarnConfiguration conf) throws IOException {
        Path qPath = FileContext.getFileContext().makeQualified(resPath);
        FileStatus status = FileSystem.get((Configuration)conf).getFileStatus(qPath);
        res.setResource(ConverterUtils.getYarnUrlFromPath((Path)qPath));
        res.setSize(status.getLen());
        res.setTimestamp(status.getModificationTime());
        res.setType(LocalResourceType.FILE);
        res.setVisibility(LocalResourceVisibility.PUBLIC);
    }
}

