/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.yarn.demo;

import ca.training.bigdata.yarn.demo.DemoUtils;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;

public class DemoClient {
    private YarnConfiguration conf;

    public static void main(String[] args) {
        System.out.println("Client: Initializing");
        try {
            new DemoClient().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void run() throws Exception {
        this.conf = new YarnConfiguration();
        YarnClient client = YarnClient.createYarnClient();
        client.init((Configuration)this.conf);
        client.start();
        YarnClientApplication app = client.createApplication();
        ContainerLaunchContext amCLC = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amCLC.setCommands(Collections.singletonList("$JAVA_HOME/bin/java -Xmx256M ca.training.bigdata.yarn.demo.DemoAppMaster 1><LOG_DIR>/stdout 2><LOG_DIR>/stderr"));
        LocalResource jar = (LocalResource)Records.newRecord(LocalResource.class);
        DemoUtils.setUpLocalResource(DemoUtils.YARNAPP_JAR_PATH, jar, this.conf);
        amCLC.setLocalResources(Collections.singletonMap("YarnApplicationDemo-1.0-SNAPSHOT.jar", jar));
        HashMap<String, String> env = new HashMap<String, String>();
        DemoUtils.setUpEnv(env, this.conf);
        amCLC.setEnvironment(env);
        Resource res = (Resource)Records.newRecord(Resource.class);
        res.setMemory(256);
        res.setVirtualCores(1);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        appContext.setApplicationName("Yarn Application Demo");
        appContext.setQueue("default");
        appContext.setAMContainerSpec(amCLC);
        appContext.setResource(res);
        ApplicationId id = appContext.getApplicationId();
        System.out.println("Client: Submitting " + id);
        client.submitApplication(appContext);
        ApplicationReport appReport = client.getApplicationReport(id);
        YarnApplicationState appState = appReport.getYarnApplicationState();
        while (appState != YarnApplicationState.FINISHED && appState != YarnApplicationState.KILLED && appState != YarnApplicationState.FAILED) {
            Thread.sleep(1000L);
            appReport = client.getApplicationReport(id);
            appState = appReport.getYarnApplicationState();
        }
        System.out.println("Client: Finished " + id + " with state " + appState);
    }
}

