/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.yarn.demo;

import ca.training.bigdata.yarn.demo.DemoUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;

public class DemoAppMaster
implements AMRMClientAsync.CallbackHandler {
    private YarnConfiguration conf = new YarnConfiguration();
    private NMClient nmClient;
    private int containerCount = 3;

    public static void main(String[] args) {
        System.out.println("AppMaster: Initializing");
        try {
            new DemoAppMaster().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() throws Exception {
        this.conf = new YarnConfiguration();
        this.nmClient = NMClient.createNMClient();
        this.nmClient.init((Configuration)this.conf);
        this.nmClient.start();
        AMRMClientAsync rmClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)this);
        rmClient.init((Configuration)this.conf);
        rmClient.start();
        rmClient.registerApplicationMaster("", 0, "");
        System.out.println("AppMaster: Registered");
        Priority priority = (Priority)Records.newRecord(Priority.class);
        priority.setPriority(0);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(128);
        capability.setVirtualCores(1);
        System.out.println("AppMaster: Requesting " + this.containerCount + " Containers");
        for (int i = 0; i < this.containerCount; ++i) {
            rmClient.addContainerRequest(new AMRMClient.ContainerRequest(capability, null, null, priority));
        }
        while (!this.containersFinished()) {
            Thread.sleep(100L);
        }
        System.out.println("AppMaster: Unregistered");
        rmClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, "", "");
    }

    private boolean containersFinished() {
        return this.containerCount == 0;
    }

    public void onContainersAllocated(List<Container> containers) {
        for (Container container : containers) {
            try {
                this.nmClient.startContainer(container, this.initContainer());
                System.err.println("AppMaster: Container launched " + container.getId());
            }
            catch (Exception ex) {
                System.err.println("AppMaster: Container not launched " + container.getId());
                ex.printStackTrace();
            }
        }
    }

    private ContainerLaunchContext initContainer() {
        try {
            ContainerLaunchContext cCLC = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            cCLC.setCommands(Collections.singletonList("$JAVA_HOME/bin/java -Xmx256M ca.training.bigdata.yarn.demo.DemoContainer 1><LOG_DIR>/stdout 2><LOG_DIR>/stderr"));
            LocalResource jar = (LocalResource)Records.newRecord(LocalResource.class);
            DemoUtils.setUpLocalResource(DemoUtils.YARNAPP_JAR_PATH, jar, this.conf);
            cCLC.setLocalResources(Collections.singletonMap("YarnApplicationDemo-1.0-SNAPSHOT.jar", jar));
            HashMap<String, String> env = new HashMap<String, String>();
            DemoUtils.setUpEnv(env, this.conf);
            cCLC.setEnvironment(env);
            return cCLC;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersCompleted(List<ContainerStatus> statusOfContainers) {
        for (ContainerStatus status : statusOfContainers) {
            System.err.println("AppMaster: Container finished " + status.getContainerId());
            DemoAppMaster demoAppMaster = this;
            synchronized (demoAppMaster) {
                --this.containerCount;
            }
        }
    }

    public void onError(Throwable e) {
    }

    public void onNodesUpdated(List<NodeReport> nodeReports) {
    }

    public void onShutdownRequest() {
    }

    public float getProgress() {
        return 0.0f;
    }
}

