/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import com.mongodb.BasicDBObject;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.yong3.hive.mongo.MongoTable;

public class MongoWriter
implements FileSinkOperator.RecordWriter {
    MongoTable table;

    public MongoWriter(String host, String port, String dbName, String dbUser, String dbPasswd, String colName) {
        this.table = new MongoTable(host, port, dbName, dbUser, dbPasswd, colName);
    }

    public void close(boolean abort) throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    public void write(Writable w) throws IOException {
        MapWritable map = (MapWritable)w;
        BasicDBObject dbo = new BasicDBObject();
        for (Map.Entry entry : map.entrySet()) {
            String key = ((Writable)entry.getKey()).toString();
            dbo.put(key, this.getObjectFromWritable((Writable)entry.getValue()));
        }
        this.table.save(dbo);
    }

    private Object getObjectFromWritable(Writable w) {
        if (w instanceof IntWritable) {
            return ((IntWritable)w).get();
        }
        if (w instanceof ShortWritable) {
            return ((ShortWritable)w).get();
        }
        if (w instanceof ByteWritable) {
            return ((ByteWritable)w).get();
        }
        if (w instanceof BooleanWritable) {
            return ((BooleanWritable)w).get();
        }
        if (w instanceof LongWritable) {
            return ((LongWritable)w).get();
        }
        if (w instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)w).get());
        }
        if (w instanceof DoubleWritable) {
            return ((DoubleWritable)w).get();
        }
        if (w instanceof NullWritable) {
            return null;
        }
        return w.toString();
    }
}

