/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.net.UnknownHostException;

public class MongoTable {
    private DB db;
    private DBCollection collection;

    public MongoTable(String host, String port, String dbName, String dbUser, String dbPasswd, String collectionName) {
        try {
            this.db = new Mongo(host, Integer.valueOf(port)).getDB(dbName);
            boolean auth = false;
            if (dbUser != null && !"".equals(dbUser.trim())) {
                auth = this.db.authenticate(dbUser, dbPasswd.toCharArray());
            }
            if (!auth) {
                throw new RuntimeException("database auth failed with user:" + dbUser + " and passwd:" + dbPasswd);
            }
            this.collection = this.db.getCollection(collectionName);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    public void save(BasicDBObject dbo) {
        this.collection.save(dbo);
    }

    public void close() {
        if (this.db != null) {
            this.db.getMongo().close();
        }
    }

    public long count() {
        return this.collection != null ? this.collection.count() : 0L;
    }

    public DBCursor findAll(String[] fields) {
        BasicDBObject qFields = new BasicDBObject();
        for (String field : fields) {
            qFields.put(field, (Object)1);
        }
        return this.collection.find(new BasicDBObject(), qFields);
    }

    public void drop() {
        this.collection.drop();
    }
}

