/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.yong3.hive.mongo.ConfigurationUtil;
import org.yong3.hive.mongo.MongoInputFormat;
import org.yong3.hive.mongo.MongoOutputFormat;
import org.yong3.hive.mongo.MongoSerDe;
import org.yong3.hive.mongo.MongoTable;

public class MongoStorageHandler
implements HiveStorageHandler {
    private Configuration mConf = null;

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties properties = tableDesc.getProperties();
        ConfigurationUtil.copyMongoProperties(properties, jobProperties);
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return MongoInputFormat.class;
    }

    public HiveMetaHook getMetaHook() {
        return new DummyMetaHook();
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return MongoOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return MongoSerDe.class;
    }

    public Configuration getConf() {
        return this.mConf;
    }

    public void setConf(Configuration conf) {
        this.mConf = conf;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    public void configureInputJobProperties(TableDesc desc, Map<String, String> props) {
    }

    public void configureOutputJobProperties(TableDesc desc, Map<String, String> props) {
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    private class DummyMetaHook
    implements HiveMetaHook {
        private DummyMetaHook() {
        }

        public void commitCreateTable(Table tbl) throws MetaException {
        }

        public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (!(deleteData && isExternal || !deleteData || isExternal)) {
                String dbHost = (String)tbl.getParameters().get("mongo.host");
                String dbPort = (String)tbl.getParameters().get("mongo.port");
                String dbName = (String)tbl.getParameters().get("mongo.db");
                String dbUser = (String)tbl.getParameters().get("mongo.user");
                String dbPasswd = (String)tbl.getParameters().get("mongo.passwd");
                String dbCollection = (String)tbl.getParameters().get("mongo.collection");
                MongoTable table = new MongoTable(dbHost, dbPort, dbName, dbUser, dbPasswd, dbCollection);
                table.drop();
                table.close();
            }
        }

        public void preCreateTable(Table tbl) throws MetaException {
        }

        public void preDropTable(Table tbl) throws MetaException {
        }

        public void rollbackCreateTable(Table tbl) throws MetaException {
        }

        public void rollbackDropTable(Table tbl) throws MetaException {
        }
    }
}

