/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.yong3.hive.mongo.MongoTable;

public class MongoSplit
extends FileSplit
implements InputSplit {
    private static final String[] EMPTY_ARRAY = new String[0];
    private long start;
    private long end;
    private boolean isLastSplit = false;

    public MongoSplit() {
        super((Path)null, 0L, 0L, EMPTY_ARRAY);
    }

    public MongoSplit(long start, long end, Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.start = start;
        this.end = end;
    }

    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.start = input.readLong();
        this.end = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeLong(this.start);
        output.writeLong(this.end);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isLastSplit() {
        return this.isLastSplit;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setLastSplit() {
        this.isLastSplit = true;
    }

    public long getLength() {
        return this.end - this.start;
    }

    public String[] getLocations() throws IOException {
        return EMPTY_ARRAY;
    }

    public String toString() {
        return String.format("MongoSplit(start=%s,end=%s)", this.start, this.end);
    }

    public static MongoSplit[] getSplits(JobConf conf, String dbHost, String dbPort, String dbName, String dbUser, String dbPasswd, String colName, int numSplits) {
        MongoTable table = new MongoTable(dbHost, dbPort, dbName, dbUser, dbPasswd, colName);
        long total = table.count();
        int _numSplits = numSplits < 1 || total <= (long)numSplits ? 1 : numSplits;
        long splitSize = total / (long)_numSplits;
        MongoSplit[] splits = new MongoSplit[_numSplits];
        Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)conf);
        for (int i = 0; i < _numSplits; ++i) {
            if (i + 1 == _numSplits) {
                splits[i] = new MongoSplit((long)i * splitSize, total, tablePaths[0]);
                splits[i].setLastSplit();
                continue;
            }
            splits[i] = new MongoSplit((long)i * splitSize, (long)(i + 1) * splitSize, tablePaths[0]);
        }
        return splits;
    }
}

