/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;
import org.yong3.hive.mongo.ConfigurationUtil;

public class MongoSerDe
implements SerDe {
    static final String HIVE_TYPE_DOUBLE = "double";
    static final String HIVE_TYPE_FLOAT = "float";
    static final String HIVE_TYPE_BOOLEAN = "boolean";
    static final String HIVE_TYPE_BIGINT = "bigint";
    static final String HIVE_TYPE_TINYINT = "tinyint";
    static final String HIVE_TYPE_SMALLINT = "smallint";
    static final String HIVE_TYPE_INT = "int";
    private final MapWritable cachedWritable = new MapWritable();
    private int fieldCount;
    private StructObjectInspector objectInspector;
    private List<String> columnNames;
    String[] columnTypesArray;
    private List<Object> row;
    Logger log = Logger.getLogger(MongoSerDe.class);

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnString = tbl.getProperty("mongo.column.mapping");
        if (StringUtils.isBlank((String)columnString)) {
            throw new SerDeException("No column mapping found, use mongo.column.mapping");
        }
        String[] columnNamesArray = ConfigurationUtil.getAllColumns(columnString);
        this.fieldCount = columnNamesArray.length;
        this.columnNames = new ArrayList<String>(columnNamesArray.length);
        this.columnNames.addAll(Arrays.asList(columnNamesArray));
        this.log.debug((Object)("column names in mongo collection: " + this.columnNames));
        String hiveColumnNameProperty = tbl.getProperty("columns");
        List<Object> hiveColumnNameArray = new ArrayList();
        if (hiveColumnNameProperty != null && hiveColumnNameProperty.length() > 0) {
            hiveColumnNameArray = Arrays.asList(hiveColumnNameProperty.split("[,:;]"));
        }
        this.log.debug((Object)("column names in hive table: " + hiveColumnNameArray));
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnTypesArray = columnTypeProperty.split("[,:;]");
        this.log.debug((Object)("column types in hive table: " + this.columnTypesArray));
        ArrayList<Object> fieldOIs = new ArrayList<Object>(columnNamesArray.length);
        for (int i = 0; i < columnNamesArray.length; ++i) {
            if (HIVE_TYPE_INT.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
                continue;
            }
            if (HIVE_TYPE_SMALLINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaShortObjectInspector);
                continue;
            }
            if (HIVE_TYPE_TINYINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaByteObjectInspector);
                continue;
            }
            if (HIVE_TYPE_BIGINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
                continue;
            }
            if (HIVE_TYPE_BOOLEAN.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaBooleanObjectInspector);
                continue;
            }
            if (HIVE_TYPE_FLOAT.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaFloatObjectInspector);
                continue;
            }
            if (HIVE_TYPE_DOUBLE.equalsIgnoreCase(this.columnTypesArray[i])) {
                fieldOIs.add(PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
                continue;
            }
            fieldOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        this.objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(hiveColumnNameArray, fieldOIs);
        this.row = new ArrayList<Object>(columnNamesArray.length);
    }

    public Object deserialize(Writable wr) throws SerDeException {
        if (!(wr instanceof MapWritable)) {
            throw new SerDeException("Expected MapWritable, received " + wr.getClass().getName());
        }
        MapWritable input = (MapWritable)wr;
        Text t = new Text();
        this.row.clear();
        for (int i = 0; i < this.fieldCount; ++i) {
            t.set(this.columnNames.get(i));
            Writable value = input.get((Object)t);
            if (value != null && !NullWritable.get().equals((Object)value)) {
                if (HIVE_TYPE_INT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()).intValue());
                    continue;
                }
                if (HIVE_TYPE_SMALLINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()).shortValue());
                    continue;
                }
                if (HIVE_TYPE_TINYINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()).byteValue());
                    continue;
                }
                if (HIVE_TYPE_BIGINT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Long.valueOf(value.toString()));
                    continue;
                }
                if (HIVE_TYPE_BOOLEAN.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Boolean.valueOf(value.toString()));
                    continue;
                }
                if (HIVE_TYPE_FLOAT.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Float.valueOf(Double.valueOf(value.toString()).floatValue()));
                    continue;
                }
                if (HIVE_TYPE_DOUBLE.equalsIgnoreCase(this.columnTypesArray[i])) {
                    this.row.add(Double.valueOf(value.toString()));
                    continue;
                }
                this.row.add(value.toString());
                continue;
            }
            this.row.add(null);
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector inspector) throws SerDeException {
        StructObjectInspector structInspector = (StructObjectInspector)inspector;
        List fields = structInspector.getAllStructFieldRefs();
        if (fields.size() != this.columnNames.size()) {
            throw new SerDeException(String.format("Required %d columns, received %d.", this.columnNames.size(), fields.size()));
        }
        this.cachedWritable.clear();
        for (int c = 0; c < this.fieldCount; ++c) {
            StructField structField = (StructField)fields.get(c);
            if (structField == null) continue;
            Object field = structInspector.getStructFieldData(obj, (StructField)fields.get(c));
            AbstractPrimitiveObjectInspector fieldOI = (AbstractPrimitiveObjectInspector)((StructField)fields.get(c)).getFieldObjectInspector();
            Object value = (Writable)fieldOI.getPrimitiveWritableObject(field);
            if (value == null) {
                value = PrimitiveObjectInspector.PrimitiveCategory.STRING.equals((Object)fieldOI.getPrimitiveCategory()) ? NullWritable.get() : new IntWritable(0);
            }
            this.cachedWritable.put((Writable)new Text(this.columnNames.get(c)), value);
        }
        return this.cachedWritable;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

