/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.yong3.hive.mongo.MongoSplit;
import org.yong3.hive.mongo.MongoTable;

public class MongoReader
implements RecordReader<LongWritable, MapWritable> {
    static final int BATCH_SIZE = 8192;
    MongoTable table;
    MongoSplit split;
    DBCursor cursor;
    long pos;
    String[] readColumns;

    public MongoReader(String dbHost, String dbPort, String dbName, String dbUser, String dbPasswd, String colName, MongoSplit split, String[] readColumns) {
        this.table = new MongoTable(dbHost, dbPort, dbName, dbUser, dbPasswd, colName);
        this.split = split;
        this.readColumns = readColumns;
        this.cursor = this.table.findAll(readColumns).batchSize(8192).skip((int)split.getStart());
        if (!split.isLastSplit()) {
            this.cursor.limit((int)split.getLength());
        }
    }

    public void close() throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public float getProgress() throws IOException {
        return this.split.getLength() > 0L ? (float)this.pos / (float)this.split.getLength() : 1.0f;
    }

    public boolean next(LongWritable keyHolder, MapWritable valueHolder) throws IOException {
        if (!this.cursor.hasNext()) {
            return false;
        }
        DBObject record = this.cursor.next();
        keyHolder.set(this.pos);
        for (int i = 0; i < this.readColumns.length; ++i) {
            String key = this.readColumns[i];
            Object vObj = "id".equals(key) ? record.get("_id") : record.get(key);
            NullWritable value = vObj == null ? NullWritable.get() : new Text(vObj.toString());
            valueHolder.put((Writable)new Text(key), (Writable)value);
        }
        ++this.pos;
        return true;
    }
}

