/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.yong3.hive.mongo.ConfigurationUtil;
import org.yong3.hive.mongo.MongoReader;
import org.yong3.hive.mongo.MongoSplit;

public class MongoInputFormat
extends HiveInputFormat<LongWritable, MapWritable> {
    public RecordReader<LongWritable, MapWritable> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        String[] cols;
        List readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
        boolean addAll = readColIDs.size() == 0;
        String columnString = conf.get("mongo.column.mapping");
        if (StringUtils.isBlank((String)columnString)) {
            throw new IOException("no column mapping found!");
        }
        String[] columns = ConfigurationUtil.getAllColumns(columnString);
        if (readColIDs.size() > columns.length) {
            throw new IOException("read column count larger than that in column mapping string!");
        }
        if (addAll) {
            cols = columns;
        } else {
            cols = new String[readColIDs.size()];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = columns[(Integer)readColIDs.get(i)];
            }
        }
        String filterExprSerialized = conf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized != null) {
            // empty if block
        }
        return new MongoReader(ConfigurationUtil.getDBHost((Configuration)conf), ConfigurationUtil.getDBPort((Configuration)conf), ConfigurationUtil.getDBName((Configuration)conf), ConfigurationUtil.getDBUser((Configuration)conf), ConfigurationUtil.getDBPassword((Configuration)conf), ConfigurationUtil.getCollectionName((Configuration)conf), (MongoSplit)split, cols);
    }

    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        return MongoSplit.getSplits(conf, ConfigurationUtil.getDBHost((Configuration)conf), ConfigurationUtil.getDBPort((Configuration)conf), ConfigurationUtil.getDBName((Configuration)conf), ConfigurationUtil.getDBUser((Configuration)conf), ConfigurationUtil.getDBPassword((Configuration)conf), ConfigurationUtil.getCollectionName((Configuration)conf), numSplits);
    }

    void dumpFilterExpr(ExprNodeDesc expr) {
        if (expr == null) {
            return;
        }
        System.err.println("cols=" + expr.getCols() + ", expr=" + expr.getExprString());
        List children = expr.getChildren();
        if (children != null && children.size() > 0) {
            System.err.println("children=");
            for (ExprNodeDesc e : children) {
                this.dumpFilterExpr(e);
            }
        }
    }
}

