/*
 * Decompiled with CFR 0.152.
 */
package org.yong3.hive.mongo;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationUtil {
    public static final String DB_NAME = "mongo.db";
    public static final String COLLECTION_NAME = "mongo.collection";
    public static final String DB_HOST = "mongo.host";
    public static final String DB_PORT = "mongo.port";
    public static final String COLUMN_MAPPING = "mongo.column.mapping";
    public static final String DB_USER = "mongo.user";
    public static final String DB_PASSWD = "mongo.passwd";
    public static final Set<String> ALL_PROPERTIES = ImmutableSet.of("mongo.db", "mongo.collection", "mongo.host", "mongo.port", "mongo.column.mapping", "mongo.user", new String[]{"mongo.passwd"});

    public static final String getDBName(Configuration conf) {
        return conf.get(DB_NAME);
    }

    public static final String getCollectionName(Configuration conf) {
        return conf.get(COLLECTION_NAME);
    }

    public static final String getDBHost(Configuration conf) {
        return conf.get(DB_HOST);
    }

    public static final String getDBPort(Configuration conf) {
        return conf.get(DB_PORT);
    }

    public static final String getDBUser(Configuration conf) {
        return conf.get(DB_USER);
    }

    public static final String getDBPassword(Configuration conf) {
        return conf.get(DB_PASSWD);
    }

    public static final String getColumnMapping(Configuration conf) {
        return conf.get(COLUMN_MAPPING);
    }

    public static void copyMongoProperties(Properties from, Map<String, String> to) {
        for (String key : ALL_PROPERTIES) {
            String value = from.getProperty(key);
            if (value == null) continue;
            to.put(key, value);
        }
    }

    public static String[] getAllColumns(String columnMappingString) {
        return columnMappingString.split(",");
    }
}

