/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.net.DefaultEvaluator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SMTPAppender
extends AppenderSkeleton {
    private String to;
    private String cc;
    private String bcc;
    private String from;
    private String subject;
    private String smtpHost;
    private String smtpUsername;
    private String smtpPassword;
    private boolean smtpDebug = false;
    private int bufferSize = 512;
    private boolean locationInfo = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;
    static /* synthetic */ Class class$org$apache$log4j$spi$TriggeringEventEvaluator;

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator triggeringEventEvaluator) {
        this.evaluator = triggeringEventEvaluator;
    }

    public void activateOptions() {
        Session session = this.createSession();
        this.msg = new MimeMessage(session);
        try {
            this.addressMessage(this.msg);
            if (this.subject != null) {
                this.msg.setSubject(this.subject);
            }
        }
        catch (MessagingException messagingException) {
            LogLog.error("Could not activate SMTPAppender options.", messagingException);
        }
    }

    protected void addressMessage(Message message) throws MessagingException {
        if (this.from != null) {
            message.setFrom((Address)this.getAddress(this.from));
        } else {
            message.setFrom();
        }
        if (this.to != null && this.to.length() > 0) {
            message.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
        }
        if (this.cc != null && this.cc.length() > 0) {
            message.setRecipients(Message.RecipientType.CC, (Address[])this.parseAddress(this.cc));
        }
        if (this.bcc != null && this.bcc.length() > 0) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])this.parseAddress(this.bcc));
        }
    }

    protected Session createSession() {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        if (this.smtpHost != null) {
            ((Hashtable)properties).put("mail.smtp.host", this.smtpHost);
        }
        Authenticator authenticator = null;
        if (this.smtpPassword != null && this.smtpUsername != null) {
            ((Hashtable)properties).put("mail.smtp.auth", "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPAppender.this.smtpUsername, SMTPAppender.this.smtpPassword);
                }
            };
        }
        Session session = Session.getInstance((Properties)properties, authenticator);
        if (this.smtpDebug) {
            session.setDebug(this.smtpDebug);
        }
        return session;
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        loggingEvent.getThreadName();
        loggingEvent.getNDC();
        loggingEvent.getMDCCopy();
        if (this.locationInfo) {
            loggingEvent.getLocationInformation();
        }
        this.cb.add(loggingEvent);
        if (this.evaluator.isTriggeringEvent(loggingEvent)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String string2) {
        try {
            return new InternetAddress(string2);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string2 + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String string2) {
        try {
            return InternetAddress.parse((String)string2, (boolean)true);
        }
        catch (AddressException addressException) {
            this.errorHandler.error("Could not parse address [" + string2 + "].", (Exception)((Object)addressException), 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        try {
            LoggingEvent loggingEvent;
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = this.layout.getHeader();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            int n = this.cb.length();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray;
                loggingEvent = this.cb.get();
                stringBuffer.append(this.layout.format(loggingEvent));
                if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        stringBuffer.append(stringArray[n3]);
                        stringBuffer.append(Layout.LINE_SEP);
                        ++n3;
                    }
                }
                ++n2;
            }
            string2 = this.layout.getFooter();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            mimeBodyPart.setContent((Object)stringBuffer.toString(), this.layout.getContentType());
            loggingEvent = new MimeMultipart();
            loggingEvent.addBodyPart((BodyPart)mimeBodyPart);
            this.msg.setContent((Multipart)loggingEvent);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception exception) {
            LogLog.error("Error occured while sending e-mail notification.", exception);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String string2) {
        this.from = string2;
    }

    public void setSubject(String string2) {
        this.subject = string2;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
        this.cb.resize(n);
    }

    public void setSMTPHost(String string2) {
        this.smtpHost = string2;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String string2) {
        this.to = string2;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String string2) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(string2, class$org$apache$log4j$spi$TriggeringEventEvaluator == null ? (class$org$apache$log4j$spi$TriggeringEventEvaluator = SMTPAppender.class$("org.apache.log4j.spi.TriggeringEventEvaluator")) : class$org$apache$log4j$spi$TriggeringEventEvaluator, this.evaluator);
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setCc(String string2) {
        this.cc = string2;
    }

    public String getCc() {
        return this.cc;
    }

    public void setBcc(String string2) {
        this.bcc = string2;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setSMTPPassword(String string2) {
        this.smtpPassword = string2;
    }

    public void setSMTPUsername(String string2) {
        this.smtpUsername = string2;
    }

    public void setSMTPDebug(boolean bl) {
        this.smtpDebug = bl;
    }

    public String getSMTPPassword() {
        return this.smtpPassword;
    }

    public String getSMTPUsername() {
        return this.smtpUsername;
    }

    public boolean getSMTPDebug() {
        return this.smtpDebug;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

