/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.chainsaw.EventDetails;

class MyTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(class$org$apache$log4j$chainsaw$MyTableModel == null ? (class$org$apache$log4j$chainsaw$MyTableModel = MyTableModel.class$("org.apache.log4j.chainsaw.MyTableModel")) : class$org$apache$log4j$chainsaw$MyTableModel);
    private static final Comparator MY_COMP = new Comparator(){

        public int compare(Object aObj1, Object aObj2) {
            if (aObj1 == null && aObj2 == null) {
                return 0;
            }
            if (aObj1 == null) {
                return -1;
            }
            if (aObj2 == null) {
                return 1;
            }
            EventDetails le1 = (EventDetails)aObj1;
            EventDetails le2 = (EventDetails)aObj2;
            if (le1.getTimeStamp() < le2.getTimeStamp()) {
                return 1;
            }
            return -1;
        }
    };
    private static final String[] COL_NAMES = new String[]{"Time", "Priority", "Trace", "Category", "NDC", "Message"};
    private static final EventDetails[] EMPTY_LIST = new EventDetails[0];
    private static final DateFormat DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 2);
    private final Object mLock = new Object();
    private final SortedSet mAllEvents = new TreeSet(MY_COMP);
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List mPendingEvents = new ArrayList();
    private boolean mPaused = false;
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mNDCFilter = "";
    private String mCategoryFilter = "";
    private Priority mPriorityFilter = Priority.DEBUG;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$MyTableModel;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    MyTableModel() {
        Thread t = new Thread(new Processor());
        t.setDaemon(true);
        t.start();
    }

    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mFilteredEvents.length;
            return n;
        }
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int aCol) {
        return COL_NAMES[aCol];
    }

    public Class getColumnClass(int aCol) {
        Class clazz = aCol == 2 ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MyTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean) : (class$java$lang$Object == null ? (class$java$lang$Object = MyTableModel.class$("java.lang.Object")) : class$java$lang$Object);
        return clazz;
    }

    public Object getValueAt(int aRow, int aCol) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails event = this.mFilteredEvents[aRow];
            if (aCol == 0) {
                String string2 = DATE_FORMATTER.format(new Date(event.getTimeStamp()));
                return string2;
            }
            if (aCol == 1) {
                Priority priority = event.getPriority();
                return priority;
            }
            if (aCol == 2) {
                Boolean bl = event.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
                return bl;
            }
            if (aCol == 3) {
                String string3 = event.getCategoryName();
                return string3;
            }
            if (aCol == 4) {
                String string4 = event.getNDC();
                return string4;
            }
            String string5 = event.getMessage();
            return string5;
        }
    }

    public void setPriorityFilter(Priority aPriority) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPriorityFilter = aPriority;
            this.updateFilteredEvents(false);
        }
    }

    public void setThreadFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setMessageFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setNDCFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNDCFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void setCategoryFilter(String aStr) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = aStr.trim();
            this.updateFilteredEvents(false);
        }
    }

    public void addEvent(EventDetails aEvent) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(aEvent);
        }
    }

    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.mPaused;
            return bl;
        }
    }

    public EventDetails getEventDetails(int aRow) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails eventDetails = this.mFilteredEvents[aRow];
            return eventDetails;
        }
    }

    private void updateFilteredEvents(boolean aInsertedToFront) {
        long start = System.currentTimeMillis();
        ArrayList<EventDetails> filtered2 = new ArrayList<EventDetails>();
        int size2 = this.mAllEvents.size();
        Iterator it = this.mAllEvents.iterator();
        while (it.hasNext()) {
            EventDetails event = (EventDetails)it.next();
            if (!this.matchFilter(event)) continue;
            filtered2.add(event);
        }
        EventDetails lastFirst = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = filtered2.toArray(EMPTY_LIST);
        if (aInsertedToFront && lastFirst != null) {
            int index2 = filtered2.indexOf(lastFirst);
            if (index2 < 1) {
                LOG.warn("In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, index2 - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long end = System.currentTimeMillis();
        LOG.debug("Total time [ms]: " + (end - start) + " in update, size: " + size2);
    }

    private boolean matchFilter(EventDetails aEvent) {
        if (aEvent.getPriority().isGreaterOrEqual(this.mPriorityFilter) && aEvent.getThreadName().indexOf(this.mThreadFilter) >= 0 && aEvent.getCategoryName().indexOf(this.mCategoryFilter) >= 0 && (this.mNDCFilter.length() == 0 || aEvent.getNDC() != null && aEvent.getNDC().indexOf(this.mNDCFilter) >= 0)) {
            String rm2 = aEvent.getMessage();
            if (rm2 == null) {
                return this.mMessageFilter.length() == 0;
            }
            return rm2.indexOf(this.mMessageFilter) >= 0;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused) {
                        continue;
                    }
                    boolean toHead = true;
                    boolean needUpdate = false;
                    Iterator it = MyTableModel.this.mPendingEvents.iterator();
                    while (it.hasNext()) {
                        EventDetails event = (EventDetails)it.next();
                        MyTableModel.this.mAllEvents.add(event);
                        toHead = toHead && event == MyTableModel.this.mAllEvents.first();
                        boolean bl = needUpdate = needUpdate || MyTableModel.this.matchFilter(event);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (needUpdate) {
                        MyTableModel.this.updateFilteredEvents(toHead);
                    }
                }
            }
        }
    }
}

