/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ListOffsetResponse
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentResponseSchema(ApiKeys.LIST_OFFSETS.id);
    private static String RESPONSES_KEY_NAME = "responses";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITIONS_KEY_NAME = "partition_responses";
    private static String PARTITION_KEY_NAME = "partition";
    private static String ERROR_CODE_KEY_NAME = "error_code";
    private static String OFFSETS_KEY_NAME = "offsets";
    private final Map<TopicPartition, PartitionData> responseData;

    public ListOffsetResponse(Map<TopicPartition, PartitionData> responseData) {
        super(new Struct(curSchema));
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData offsetPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)offsetPartitionData.errorCode);
                partitionData.set(OFFSETS_KEY_NAME, (Object)offsetPartitionData.offsets.toArray());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        this.responseData = responseData;
    }

    public ListOffsetResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                Object[] offsets = partitionResponse.getArray(OFFSETS_KEY_NAME);
                ArrayList<Long> offsetsList = new ArrayList<Long>();
                for (Object offset : offsets) {
                    offsetsList.add((Long)offset);
                }
                PartitionData partitionData = new PartitionData(errorCode, offsetsList);
                this.responseData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public static ListOffsetResponse parse(ByteBuffer buffer) {
        return new ListOffsetResponse((Struct)curSchema.read(buffer));
    }

    public static final class PartitionData {
        public final short errorCode;
        public final List<Long> offsets;

        public PartitionData(short errorCode, List<Long> offsets) {
            this.errorCode = errorCode;
            this.offsets = offsets;
        }
    }
}

