/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.runtime.LongRef;

public final class ByteBufferMessageSet$ {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong offsetCounter, CompressionCodec compressionCodec, Seq<Message> messages) {
        ByteBuffer byteBuffer;
        if (messages.size() == 0) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
            return byteBuffer;
        }
        CompressionCodec compressionCodec2 = compressionCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages));
            messages.foreach(new Serializable(offsetCounter, buffer){
                public static final long serialVersionUID = 0L;
                private final AtomicLong offsetCounter$1;
                private final ByteBuffer buffer$1;

                public final void apply(Message message) {
                    ByteBufferMessageSet$.MODULE$.writeMessage(this.buffer$1, message, this.offsetCounter$1.getAndIncrement());
                }
                {
                    this.offsetCounter$1 = offsetCounter$1;
                    this.buffer$1 = buffer$1;
                }
            });
            buffer.rewind();
            byteBuffer = buffer;
            return byteBuffer;
        }
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(MessageSet$.MODULE$.messageSetSize(messages));
        DataOutputStream output = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec, byteArrayStream));
        LongRef offset = LongRef.create(-1L);
        try {
            messages.foreach(new Serializable(offsetCounter, output, offset){
                public static final long serialVersionUID = 0L;
                private final AtomicLong offsetCounter$1;
                private final DataOutputStream output$1;
                private final LongRef offset$1;

                public final void apply(Message message) {
                    this.offset$1.elem = this.offsetCounter$1.getAndIncrement();
                    this.output$1.writeLong(this.offset$1.elem);
                    this.output$1.writeInt(message.size());
                    this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                }
                {
                    this.offsetCounter$1 = offsetCounter$1;
                    this.output$1 = output$1;
                    this.offset$1 = offset$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        output.close();
        byte[] bytes = byteArrayStream.toByteArray();
        Message message = new Message(bytes, compressionCodec);
        ByteBuffer buffer = ByteBuffer.allocate(message.size() + MessageSet$.MODULE$.LogOverhead());
        this.writeMessage(buffer, message, offset.elem);
        buffer.rewind();
        byteBuffer = buffer;
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBufferMessageSet decompress(Message message) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] intermediateBuffer = new byte[1024];
        InputStream compressed = CompressionFactory$.MODULE$.apply(message.compressionCodec(), inputStream);
        try {
            ((Stream)package$.MODULE$.Stream().continually(new Serializable(intermediateBuffer, compressed){
                public static final long serialVersionUID = 0L;
                private final byte[] intermediateBuffer$1;
                private final InputStream compressed$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.compressed$1.read(this.intermediateBuffer$1);
                }
                {
                    this.intermediateBuffer$1 = intermediateBuffer$1;
                    this.compressed$1 = compressed$1;
                }
            }).takeWhile((Function1)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x$1) {
                    return this.apply$mcZI$sp(x$1);
                }

                public boolean apply$mcZI$sp(int x$1) {
                    return x$1 > 0;
                }
            }))).foreach(new Serializable(outputStream, intermediateBuffer){
                public static final long serialVersionUID = 0L;
                private final ByteArrayOutputStream outputStream$1;
                private final byte[] intermediateBuffer$1;

                public final void apply(int dataRead) {
                    this.apply$mcVI$sp(dataRead);
                }

                public void apply$mcVI$sp(int dataRead) {
                    this.outputStream$1.write(this.intermediateBuffer$1, 0, dataRead);
                }
                {
                    this.outputStream$1 = outputStream$1;
                    this.intermediateBuffer$1 = intermediateBuffer$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        compressed.close();
        ByteBuffer outputBuffer = ByteBuffer.allocate(outputStream.size());
        outputBuffer.put(outputStream.toByteArray());
        outputBuffer.rewind();
        return new ByteBufferMessageSet(outputBuffer);
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

