/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.util.Comparator;
import smile.sort.SortUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSort {
    private static final int M = 7;
    private static final int NSTACK = 64;

    public static int[] sort(int[] arr) {
        int[] order = new int[arr.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(arr, order);
        return order;
    }

    public static void sort(int[] arr, int[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(int[] arr, int[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(int[] arr, Object[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(int[] arr, Object[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static int[] sort(float[] arr) {
        int[] order = new int[arr.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(arr, order);
        return order;
    }

    public static void sort(float[] arr, int[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(float[] arr, int[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(float[] arr, float[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(float[] arr, float[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            float b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(float[] arr, Object[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(float[] arr, Object[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static int[] sort(double[] arr) {
        int[] order = new int[arr.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(arr, order);
        return order;
    }

    public static void sort(double[] arr, int[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(double[] arr, int[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(double[] arr, double[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(double[] arr, double[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            double b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(double[] arr, Object[] brr) {
        QuickSort.sort(arr, brr, arr.length);
    }

    public static void sort(double[] arr, Object[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && !(arr[i] <= a); --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> int[] sort(T[] arr) {
        int[] order = new int[arr.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(arr, (int[])order);
        return order;
    }

    public static <T extends Comparable<? super T>> void sort(T[] arr, int[] brr) {
        QuickSort.sort(arr, (int[])brr, (int)arr.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] arr, int[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && arr[i].compareTo(a) > 0; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l].compareTo(arr[l + 1]) > 0) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i].compareTo(a) < 0) {
                    continue;
                }
                while (arr[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T> void sort(T[] arr, int[] brr, int n, Comparator<T> comparator) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && comparator.compare(arr[i], a) > 0; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (comparator.compare(arr[l], arr[ir]) > 0) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (comparator.compare(arr[l + 1], arr[ir]) > 0) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (comparator.compare(arr[l], arr[l + 1]) > 0) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (comparator.compare(arr[++i], a) < 0) {
                    continue;
                }
                while (comparator.compare(arr[--j], a) > 0) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> void sort(T[] arr, Object[] brr) {
        QuickSort.sort(arr, (Object[])brr, (int)arr.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] arr, Object[] brr, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && arr[i].compareTo(a) > 0; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            SortUtils.swap(arr, k, l + 1);
            SortUtils.swap(brr, k, l + 1);
            if (arr[l].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l, ir);
                SortUtils.swap(brr, l, ir);
            }
            if (arr[l + 1].compareTo(arr[ir]) > 0) {
                SortUtils.swap(arr, l + 1, ir);
                SortUtils.swap(brr, l + 1, ir);
            }
            if (arr[l].compareTo(arr[l + 1]) > 0) {
                SortUtils.swap(arr, l, l + 1);
                SortUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i].compareTo(a) < 0) {
                    continue;
                }
                while (arr[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                SortUtils.swap(arr, i, j);
                SortUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }
}

