/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.math;

import hivemall.utils.math.MathUtils;

public final class StatsUtils {
    private StatsUtils() {
    }

    public static double probit(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        return Math.sqrt(2.0) * MathUtils.inverseErf(2.0 * p - 1.0);
    }

    public static double probit(double p, double range) {
        if (range <= 0.0) {
            throw new IllegalArgumentException("range must be > 0: " + range);
        }
        if (p == 0.0) {
            return -range;
        }
        if (p == 1.0) {
            return range;
        }
        double v = StatsUtils.probit(p);
        if (v < 0.0) {
            return Math.max(v, -range);
        }
        return Math.min(v, range);
    }
}

