/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.math;

import java.util.Random;
import javax.annotation.Nonnull;

public final class MathUtils {
    private MathUtils() {
    }

    public static int bitMask(int numberOfBits) {
        if (numberOfBits >= 32) {
            return -1;
        }
        return numberOfBits == 0 ? 0 : MathUtils.powerOf(2, numberOfBits) - 1;
    }

    public static int powerOf(int value, int powerOf) {
        if (powerOf == 0) {
            return 0;
        }
        int r = value;
        for (int x = 1; x < powerOf; ++x) {
            r *= value;
        }
        return r;
    }

    public static int bitsRequired(int value) {
        int bits = 0;
        while (value != 0) {
            ++bits;
            value >>= 1;
        }
        return bits;
    }

    public static double sigmoid(double x) {
        double x2 = Math.max(Math.min(x, 23.0), -23.0);
        return 1.0 / (1.0 + Math.exp(-x2));
    }

    public static double lnSigmoid(double x) {
        double ex = Math.exp(-x);
        return ex / (1.0 + ex);
    }

    public static double logit(double p) {
        return Math.log(p / (1.0 - p));
    }

    public static double logit(double p, double hi, double lo) {
        return Math.log((p - lo) / (hi - p));
    }

    public static double inverseErf(double x) {
        double p;
        double w = -Math.log((1.0 - x) * (1.0 + x));
        if (w < 6.25) {
            p = -3.64441206401782E-21;
            p = -1.6850591381820166E-19 + p * (w -= 3.125);
            p = 1.28584807152564E-18 + p * w;
            p = 1.1157877678025181E-17 + p * w;
            p = -1.333171662854621E-16 + p * w;
            p = 2.0972767875968562E-17 + p * w;
            p = 6.637638134358324E-15 + p * w;
            p = -4.054566272975207E-14 + p * w;
            p = -8.151934197605472E-14 + p * w;
            p = 2.6335093153082323E-12 + p * w;
            p = -1.2975133253453532E-11 + p * w;
            p = -5.415412054294628E-11 + p * w;
            p = 1.0512122733215323E-9 + p * w;
            p = -4.112633980346984E-9 + p * w;
            p = -2.9070369957882005E-8 + p * w;
            p = 4.2347877827932404E-7 + p * w;
            p = -1.3654692000834679E-6 + p * w;
            p = -1.3882523362786469E-5 + p * w;
            p = 1.8673420803405714E-4 + p * w;
            p = -7.40702534166267E-4 + p * w;
            p = -0.006033670871430149 + p * w;
            p = 0.24015818242558962 + p * w;
            p = 1.6536545626831027 + p * w;
        } else if (w < 16.0) {
            w = Math.sqrt(w) - 3.25;
            p = 2.2137376921775787E-9;
            p = 9.075656193888539E-8 + p * w;
            p = -2.7517406297064545E-7 + p * w;
            p = 1.8239629214389228E-8 + p * w;
            p = 1.5027403968909828E-6 + p * w;
            p = -4.013867526981546E-6 + p * w;
            p = 2.9234449089955446E-6 + p * w;
            p = 1.2475304481671779E-5 + p * w;
            p = -4.7318229009055734E-5 + p * w;
            p = 6.828485145957318E-5 + p * w;
            p = 2.4031110387097894E-5 + p * w;
            p = -3.550375203628475E-4 + p * w;
            p = 9.532893797373805E-4 + p * w;
            p = -0.0016882755560235047 + p * w;
            p = 0.002491442096107851 + p * w;
            p = -0.003751208507569241 + p * w;
            p = 0.005370914553590064 + p * w;
            p = 1.0052589676941592 + p * w;
            p = 3.0838856104922208 + p * w;
        } else if (!Double.isInfinite(w)) {
            w = Math.sqrt(w) - 5.0;
            p = -2.7109920616438573E-11;
            p = -2.555641816996525E-10 + p * w;
            p = 1.5076572693500548E-9 + p * w;
            p = -3.789465440126737E-9 + p * w;
            p = 7.61570120807834E-9 + p * w;
            p = -1.496002662714924E-8 + p * w;
            p = 2.914795345090108E-8 + p * w;
            p = -6.771199775845234E-8 + p * w;
            p = 2.2900482228026655E-7 + p * w;
            p = -9.9298272942317E-7 + p * w;
            p = 4.526062597223154E-6 + p * w;
            p = -1.968177810553167E-5 + p * w;
            p = 7.599527703001776E-5 + p * w;
            p = -2.1503011930044477E-4 + p * w;
            p = -1.3871931833623122E-4 + p * w;
            p = 1.0103004648645344 + p * w;
            p = 4.849906401408584 + p * w;
        } else {
            p = Double.POSITIVE_INFINITY;
        }
        return p * x;
    }

    public static int moduloPowerOfTwo(int x, int powerOfTwoY) {
        return x & powerOfTwoY - 1;
    }

    public static float l2norm(float[] elements) {
        double sqsum = 0.0;
        for (float e : elements) {
            sqsum += (double)(e * e);
        }
        return (float)Math.sqrt(sqsum);
    }

    public static double gaussian(double mean, double stddev, @Nonnull Random rnd) {
        return mean + stddev * rnd.nextGaussian();
    }

    public static double lognormal(double mean, double stddev, @Nonnull Random rnd) {
        return Math.exp(MathUtils.gaussian(mean, stddev, rnd));
    }

    public static int sign(short v) {
        return v < 0 ? -1 : 1;
    }

    public static float sign(float v) {
        return v < 0.0f ? -1.0f : 1.0f;
    }

    public static double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static boolean equals(@Nonnull float value, float expected, float delta) {
        return !(Math.abs(expected - value) > delta);
    }

    public static boolean equals(@Nonnull double value, double expected, double delta) {
        return !(Math.abs(expected - value) > delta);
    }

    public static boolean almostEquals(@Nonnull float value, float expected, float delta) {
        return MathUtils.equals(value, expected, 1.0E-15f);
    }

    public static boolean almostEquals(@Nonnull double value, double expected, double delta) {
        return MathUtils.equals(value, expected, 1.0E-15);
    }

    public static boolean closeToZero(@Nonnull float value) {
        return !(Math.abs(value) > 1.0E-15f);
    }

    public static boolean closeToZero(@Nonnull double value) {
        return !(Math.abs(value) > 1.0E-15);
    }
}

