/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang.mutable;

import hivemall.utils.lang.Copyable;
import java.io.Serializable;

public final class MutableLong
extends Number
implements Copyable<MutableLong>,
Comparable<MutableLong>,
Serializable {
    private static final long serialVersionUID = 4215176730382645660L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(Number value) {
        this.value = value.longValue();
    }

    public void addValue(long o) {
        this.value += o;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value.longValue();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void copyTo(MutableLong another) {
        another.setValue(this.value);
    }

    @Override
    public void copyFrom(MutableLong another) {
        this.value = another.value;
    }

    @Override
    public int compareTo(MutableLong other) {
        return MutableLong.compare(this.value, other.value);
    }

    private static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).longValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

