/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang.mutable;

import hivemall.utils.lang.Copyable;
import java.io.Serializable;

public final class MutableFloat
extends Number
implements Copyable<MutableFloat>,
Comparable<MutableFloat>,
Serializable {
    private static final long serialVersionUID = 1758508142164954048L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float value) {
        this.value = value;
    }

    public MutableFloat(Number value) {
        this.value = value.floatValue();
    }

    public void addValue(float o) {
        this.value += o;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value.floatValue();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void copyTo(MutableFloat another) {
        another.setValue(this.value);
    }

    @Override
    public void copyFrom(MutableFloat another) {
        this.value = another.value;
    }

    @Override
    public int compareTo(MutableFloat other) {
        return Float.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableFloat && Float.floatToIntBits(((MutableFloat)obj).value) == Float.floatToIntBits(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

