/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang.mutable;

import hivemall.utils.lang.Copyable;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class MutableDouble
extends Number
implements Copyable<MutableDouble>,
Comparable<MutableDouble>,
Serializable {
    private static final long serialVersionUID = 3275291486084936953L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this.value = value.doubleValue();
    }

    public void addValue(double o) {
        this.value += o;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void copyTo(MutableDouble another) {
        another.setValue(this.value);
    }

    @Override
    public void copyFrom(MutableDouble another) {
        this.value = another.value;
    }

    @Override
    public int compareTo(MutableDouble other) {
        return Double.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableDouble && Double.doubleToLongBits(((MutableDouble)obj).value) == Double.doubleToLongBits(this.value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Nonnull
    public static MutableDouble[] initArray(int size, double defaultValue) {
        MutableDouble[] array = new MutableDouble[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new MutableDouble(defaultValue);
        }
        return array;
    }
}

