/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

public final class Primitives {
    public static final int INT_BYTES = 4;
    public static final int DOUBLE_BYTES = 8;

    private Primitives() {
    }

    public static int toUnsignedShort(short v) {
        return v & 0xFFFF;
    }

    public static int toUnsignedInt(byte x) {
        return x & 0xFF;
    }

    public static short parseShort(String s, short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Short.parseShort(s);
    }

    public static int parseInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static long parseLong(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Long.parseLong(s);
    }

    public static float parseFloat(String s, float defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Double.parseDouble(s);
    }

    public static boolean parseBoolean(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(s);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off] = (byte)(val >>> 8);
    }

    public static int toIntExact(long longValue) {
        int casted = (int)longValue;
        if ((long)casted != longValue) {
            throw new ArithmeticException("integer overflow: " + longValue);
        }
        return casted;
    }

    public static int castToInt(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return result;
    }
}

