/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.text.DecimalFormat;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static int parseInt(String s) {
        int endIndex = s.length() - 1;
        char last = s.charAt(endIndex);
        if (Character.isLetter(last)) {
            String numstr = s.substring(0, endIndex);
            int i = Integer.parseInt(numstr);
            switch (last) {
                case 'K': 
                case 'k': {
                    i *= 1000;
                    break;
                }
                case 'M': 
                case 'm': {
                    i *= 1000000;
                    break;
                }
                case 'G': 
                case 'g': {
                    i *= 1000000000;
                    break;
                }
                default: {
                    throw new NumberFormatException("Invalid number format: " + s);
                }
            }
            return i;
        }
        return Integer.parseInt(s);
    }

    public static int parseInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return NumberUtils.parseInt(s);
    }

    public static String formatNumber(long number) {
        DecimalFormat f = new DecimalFormat("#,###");
        return f.format(number);
    }

    public static String prettySize(long size) {
        if (size < 0L) {
            return "N/A";
        }
        if (size < 1024L) {
            return size + " bytes";
        }
        float kb = (float)size / 1024.0f;
        if (kb < 1024.0f) {
            return String.format("%.1f KiB", Float.valueOf(kb));
        }
        float mb = kb / 1024.0f;
        if (mb < 1024.0f) {
            return String.format("%.1f MiB", Float.valueOf(mb));
        }
        float gb = mb / 1024.0f;
        return String.format("%.2f GiB", Float.valueOf(gb));
    }

    public static boolean isFinite(double v) {
        return v > Double.NEGATIVE_INFINITY & v < Double.POSITIVE_INFINITY;
    }

    public static boolean isFinite(float v) {
        return v > Float.NEGATIVE_INFINITY & v < Float.POSITIVE_INFINITY;
    }

    public static boolean isDigits(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

