/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

public final class HalfFloat {
    public static final short ZERO = 0;
    public static final short ONE;
    public static final float MAX_FLOAT_INTEGER = 65520.0f;
    public static final float MAX_FLOAT = 65504.0f;
    public static final float EPSILON = 9.7656E-4f;
    private static final int[] mantissatable;
    private static final int[] exponenttable;
    private static final short[] offsettable;
    private static final short[] basetable;
    private static final byte[] shifttable;

    private HalfFloat() {
    }

    public static float halfFloatToFloat(short f16) {
        int i = (f16 & 0xFFFF) >> 10 & 0xFF;
        int j = offsettable[i] + (f16 & 0x3FF) & 0x7FF;
        int bits = mantissatable[j] + exponenttable[i];
        return Float.intBitsToFloat(bits);
    }

    public static short floatToHalfFloat(float f32) {
        int bits = Float.floatToRawIntBits(f32);
        int i = bits >> 23 & 0x1FF;
        return (short)(basetable[i] + ((bits & 0x7FFFFF) >> shifttable[i]));
    }

    public static int halfFloatToFloatBits(short f16) {
        int i = f16 >> 10;
        int j = offsettable[i] + (f16 & 0x3FF);
        return mantissatable[j] + exponenttable[i];
    }

    public static short floatBitsToHalfFloat(int f32b) {
        int i = f32b >> 23 & 0x1FF;
        return (short)(basetable[i] + ((f32b & 0x7FFFFF) >> shifttable[i]));
    }

    private static void populateTableEntries() {
        HalfFloat.populateMantissaTable(mantissatable);
        HalfFloat.populateExponentTable(exponenttable);
        HalfFloat.populateOffsetTable(offsettable);
        for (int i = 0; i < 256; ++i) {
            int e = i - 127;
            if (e < -24) {
                HalfFloat.basetable[i | 0x100] = Short.MIN_VALUE;
                HalfFloat.shifttable[i | 0] = 24;
                HalfFloat.shifttable[i | 0x100] = 24;
                continue;
            }
            if (e < -14) {
                HalfFloat.basetable[i | 0] = (short)(1024 >> -e - 14);
                HalfFloat.basetable[i | 0x100] = (short)(1024 >> -e - 14 | 0x8000);
                HalfFloat.shifttable[i | 0] = (byte)(-e - 1);
                HalfFloat.shifttable[i | 0x100] = (byte)(-e - 1);
                continue;
            }
            if (e <= 15) {
                HalfFloat.basetable[i | 0] = (short)(e + 15 << 10);
                HalfFloat.basetable[i | 0x100] = (short)(e + 15 << 10 | 0x8000);
                HalfFloat.shifttable[i | 0] = 13;
                HalfFloat.shifttable[i | 0x100] = 13;
                continue;
            }
            if (e < 128) {
                HalfFloat.basetable[i | 0] = 31744;
                HalfFloat.basetable[i | 0x100] = -1024;
                HalfFloat.shifttable[i | 0] = 24;
                HalfFloat.shifttable[i | 0x100] = 24;
                continue;
            }
            HalfFloat.basetable[i | 0] = 31744;
            HalfFloat.basetable[i | 0x100] = -1024;
            HalfFloat.shifttable[i | 0] = 13;
            HalfFloat.shifttable[i | 0x100] = 13;
        }
    }

    private static void populateMantissaTable(int[] mantissatable) {
        int i;
        mantissatable[0] = 0;
        for (i = 1; i < 1024; ++i) {
            mantissatable[i] = HalfFloat.convertMantissa(i);
        }
        for (i = 1024; i < 2048; ++i) {
            mantissatable[i] = 0x38000000 + (i - 1024 << 13);
        }
    }

    private static int convertMantissa(int i) {
        int m = i << 13;
        int e = 0;
        while ((m & 0x800000) == 0) {
            e -= 0x800000;
            m <<= 1;
        }
        return (m &= 0xFF7FFFFF) | (e += 0x38800000);
    }

    private static void populateExponentTable(int[] exponenttable) {
        int i;
        exponenttable[0] = 0;
        for (i = 1; i < 31; ++i) {
            exponenttable[i] = i << 23;
        }
        exponenttable[31] = 1199570944;
        exponenttable[32] = Integer.MIN_VALUE;
        for (i = 33; i < 63; ++i) {
            exponenttable[i] = Integer.MIN_VALUE + (i - 32 << 23);
        }
        exponenttable[63] = -947912704;
    }

    private static void populateOffsetTable(short[] offsettable) {
        offsettable[0] = 0;
        for (int i = 1; i < 64; ++i) {
            offsettable[i] = 1024;
        }
        offsettable[32] = 0;
    }

    public static boolean isRepresentable(float f) {
        return Math.abs(f) <= 65520.0f;
    }

    public static boolean isRepresentable(float f, boolean strict) {
        if (strict) {
            return Math.abs(f) <= 65504.0f;
        }
        return Math.abs(f) <= 65520.0f;
    }

    public static void checkRange(float f) {
        if (Math.abs(f) > 65504.0f) {
            throw new IllegalArgumentException("Acceptable maximum weight is 65504.0: " + f);
        }
    }

    static {
        mantissatable = new int[2048];
        exponenttable = new int[64];
        offsettable = new short[64];
        basetable = new short[512];
        shifttable = new byte[512];
        HalfFloat.populateTableEntries();
        ONE = HalfFloat.floatToHalfFloat(1.0f);
    }
}

