/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Counter<E>
implements Serializable {
    private static final long serialVersionUID = 7949630590734361716L;
    private final Map<E, Integer> counts;

    public Counter() {
        this.counts = new HashMap<E, Integer>();
    }

    public Counter(@Nonnull Map<E, Integer> counts) {
        this.counts = counts;
    }

    public Map<E, Integer> getMap() {
        return this.counts;
    }

    public int increment(E key) {
        return this.increment(key, 1);
    }

    public int increment(E key, int amount) {
        Integer count = this.counts.get(key);
        if (count == null) {
            this.counts.put(key, amount);
            return 0;
        }
        int old = count;
        this.counts.put(key, old + amount);
        return old;
    }

    public int getCount(E key) {
        Integer count = this.counts.get(key);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void addAll(Map<E, Integer> counter) {
        if (counter == null) {
            return;
        }
        for (Map.Entry<E, Integer> e : counter.entrySet()) {
            this.increment(e.getKey(), e.getValue());
        }
    }

    public void addAll(Counter<E> counter) {
        if (counter == null) {
            return;
        }
        for (Map.Entry<E, Integer> e : counter.entrySet()) {
            this.increment(e.getKey(), e.getValue());
        }
    }

    public Set<Map.Entry<E, Integer>> entrySet() {
        return this.counts.entrySet();
    }

    @Nullable
    public E whichMax() {
        E maxKey = null;
        int maxValue = Integer.MIN_VALUE;
        for (Map.Entry<E, Integer> e : this.counts.entrySet()) {
            int v = e.getValue();
            if (v < maxValue) continue;
            maxValue = v;
            maxKey = e.getKey();
        }
        return maxKey;
    }

    @Nullable
    public E whichMin() {
        E minKey = null;
        int minValue = Integer.MAX_VALUE;
        for (Map.Entry<E, Integer> e : this.counts.entrySet()) {
            int v = e.getValue();
            if (v > minValue) continue;
            minValue = v;
            minKey = e.getKey();
        }
        return minKey;
    }

    public int size() {
        return this.counts.size();
    }
}

