/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.util.BitSet;
import javax.annotation.Nonnull;

public final class BitUtils {
    private BitUtils() {
    }

    public static BitSet toBitSet(String s) {
        int len = s.length();
        BitSet result = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != '1') continue;
            result.set(len - i - 1);
        }
        return result;
    }

    public static String toBinaryString(BitSet bits) {
        int len = bits.length();
        char[] data = new char[len];
        for (int i = 0; i < len; ++i) {
            data[len - i - 1] = bits.get(i) ? 49 : 48;
        }
        return String.valueOf(data);
    }

    public static int indexOfSetBit(@Nonnull BitSet bits, int nth) {
        if (nth < 0) {
            throw new IllegalArgumentException("Invalid nth: " + nth);
        }
        int pos = bits.nextSetBit(0);
        for (int i = 0; pos >= 0 && i != nth; ++i) {
            pos = bits.nextSetBit(pos + 1);
        }
        return pos;
    }

    public static int indexOfClearBit(@Nonnull BitSet bits, int nth, int lastIndex) {
        int j = bits.nextClearBit(0);
        for (int c = 0; j <= lastIndex && c != nth; ++c) {
            j = bits.nextClearBit(j + 1);
        }
        return j;
    }
}

