/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;

public final class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    public static double[] set(double[] src, int index, double value) {
        if (index >= src.length) {
            src = Arrays.copyOf(src, src.length * 2);
        }
        src[index] = value;
        return src;
    }

    public static <T> T[] set(T[] src, int index, T value) {
        if (index >= src.length) {
            src = Arrays.copyOf(src, src.length * 2);
        }
        src[index] = value;
        return src;
    }

    public static float[] toArray(List<Float> lst) {
        int ndim = lst.size();
        float[] ary = new float[ndim];
        int i = 0;
        for (float f : lst) {
            ary[i++] = f;
        }
        return ary;
    }

    public static Integer[] toObject(int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static List<Integer> toList(int[] array) {
        Integer[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    public static Long[] toObject(long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static List<Long> toList(long[] array) {
        Long[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    public static Float[] toObject(float[] array) {
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static List<Float> toList(float[] array) {
        Float[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    public static Double[] toObject(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static List<Double> toList(double[] array) {
        Double[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    public static <T> void shuffle(T[] array) {
        ArrayUtils.shuffle(array, array.length);
    }

    public static <T> void shuffle(T[] array, Random rnd) {
        ArrayUtils.shuffle(array, array.length, rnd);
    }

    public static <T> void shuffle(T[] array, int size) {
        Random rnd = new Random();
        ArrayUtils.shuffle(array, size, rnd);
    }

    public static <T> void shuffle(@Nonnull T[] array, int size, @Nonnull Random rnd) {
        for (int i = size; i > 1; --i) {
            int randomPosition = rnd.nextInt(i);
            ArrayUtils.swap(array, i - 1, randomPosition);
        }
    }

    public static void shuffle(@Nonnull int[] array, @Nonnull Random rnd) {
        for (int i = array.length; i > 1; --i) {
            int randomPosition = rnd.nextInt(i);
            ArrayUtils.swap(array, i - 1, randomPosition);
        }
    }

    public static void swap(@Nonnull Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(@Nonnull int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static Object[] subarray(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static void fill(float[] a, Random rand) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = rand.nextFloat();
        }
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex, int endIndex) {
        if (array == null) {
            return -1;
        }
        int til = Math.min(endIndex, array.length);
        if (startIndex < 0 || startIndex > til) {
            throw new IllegalArgumentException("Illegal startIndex: " + startIndex);
        }
        for (int i = startIndex; i < til; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] src) {
        int len = src.length;
        int[] dest = new int[len];
        System.arraycopy(src, 0, dest, 0, len);
        return dest;
    }

    public static void copy(int[] src, int[] dest) {
        if (src.length != dest.length) {
            throw new IllegalArgumentException("src.legnth '" + src.length + "' != dest.length '" + dest.length + "'");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public static int[] append(int[] array, int currentSize, int element) {
        if (currentSize + 1 > array.length) {
            int[] newArray = new int[currentSize * 2];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    public static int[] insert(int[] array, int currentSize, int index, int element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        int[] newArray = new int[currentSize * 2];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static boolean equals(@Nonnull float[] array, float value) {
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (array[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean almostEquals(@Nonnull float[] array, float expected) {
        return ArrayUtils.equals(array, expected, 1.0E-15f);
    }

    public static boolean equals(@Nonnull float[] array, float expected, float delta) {
        for (float actual : array) {
            if (!(Math.abs(expected - actual) > delta)) continue;
            return false;
        }
        return true;
    }
}

