/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.io.NioSegment;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class NioStatefullSegment
extends NioSegment {
    private long curPos = 0L;

    public NioStatefullSegment(File file) {
        this(file, false);
    }

    public NioStatefullSegment(File file, boolean readOnly) {
        super(file, readOnly);
    }

    public void resetPosition() {
        this.curPos = 0L;
    }

    public long getPosition() {
        return this.curPos;
    }

    public void setPosition(long pos) {
        this.curPos = pos;
    }

    public int read(@Nonnull ByteBuffer buf) throws IOException {
        int bytes = super.read(this.curPos, buf);
        this.curPos += (long)bytes;
        return bytes;
    }

    public int write(@Nonnull ByteBuffer buf) throws IOException {
        int bytes = super.write(this.curPos, buf);
        this.curPos += (long)bytes;
        return bytes;
    }

    @Override
    public int read(long filePos, @Nonnull ByteBuffer buf) throws IOException {
        int bytes = super.read(filePos, buf);
        this.curPos = filePos + (long)bytes;
        return bytes;
    }

    @Override
    public int write(long filePos, @Nonnull ByteBuffer buf) throws IOException {
        int bytes = super.write(filePos, buf);
        this.curPos = filePos + (long)bytes;
        return bytes;
    }
}

