/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.io.NIOUtils;
import hivemall.utils.io.NioSegment;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class NioFixedSegment
extends NioSegment {
    private final int recordLength;

    public NioFixedSegment(@Nonnull File file, int recordLength) {
        this(file, recordLength, false);
    }

    public NioFixedSegment(@Nonnull File file, int recordLength, boolean readOnly) {
        super(file, readOnly);
        this.recordLength = recordLength;
    }

    public int readRecords(long idx, ByteBuffer buf) throws IOException {
        long ptr = this.toPhysicalAddr(idx);
        int readBytes = NIOUtils.read(this.channel, buf, ptr);
        return readBytes == 0 ? 0 : readBytes / this.recordLength;
    }

    public long writeRecords(long idx, ByteBuffer buf) throws IOException {
        long ptr = this.toPhysicalAddr(idx);
        NIOUtils.writeFully(this.channel, buf, ptr);
        return ptr;
    }

    private long toPhysicalAddr(long logicalAddr) {
        return logicalAddr * (long)this.recordLength;
    }
}

