/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NIOUtils {
    private static final int INT_BYTES = 4;
    private static final int CHAR_BYTES = 2;

    private NIOUtils() {
    }

    public static int requiredBytes(@Nullable String s) {
        if (s == null) {
            return 4;
        }
        int size = s.length();
        return 4 + 2 * size;
    }

    public static void putString(@Nullable String s, @Nonnull ByteBuffer dst) {
        if (s == null) {
            dst.putInt(-1);
            return;
        }
        char[] array = s.toCharArray();
        int size = array.length;
        dst.putInt(size);
        for (int i = 0; i < size; ++i) {
            dst.putChar(array[i]);
        }
    }

    @Nullable
    public static String getString(@Nonnull ByteBuffer src) {
        int size = src.getInt();
        if (size == -1) {
            return null;
        }
        char[] array = new char[size];
        for (int i = 0; i < size; ++i) {
            array[i] = src.getChar();
        }
        return new String(array);
    }

    public static int read(@Nonnull FileChannel src, @Nonnull ByteBuffer dst, @Nonnegative long position) throws IOException {
        int n;
        int count = 0;
        long offset = position;
        while (dst.remaining() > 0 && (n = src.read(dst, offset)) != -1) {
            offset += (long)n;
            count += n;
        }
        return count;
    }

    public static void readFully(FileChannel src, ByteBuffer dst, long position) throws IOException {
        while (dst.remaining() > 0) {
            if (-1 != src.read(dst, position + (long)dst.position())) continue;
            throw new EOFException();
        }
    }

    public static int writeFully(@Nonnull FileChannel dst, @Nonnull ByteBuffer src, @Nonnegative long position) throws IOException {
        int count = 0;
        while (src.remaining() > 0) {
            count += dst.write(src, position + (long)src.position());
        }
        return count;
    }

    public static int writeFully(@Nonnull FileChannel dst, @Nonnull ByteBuffer src) throws IOException {
        int count = 0;
        while (src.remaining() > 0) {
            count += dst.write(src);
        }
        return count;
    }
}

