/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.codec.ZigZagLEB128Codec;
import hivemall.utils.io.FastByteArrayOutputStream;
import hivemall.utils.io.FastMultiByteArrayOutputStream;
import hivemall.utils.io.FinishableOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static void closeQuietly(Closeable channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Closeable ... channels) {
        for (Closeable c : channels) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toString(@Nonnull InputStream input) throws IOException {
        FastMultiByteArrayOutputStream output = new FastMultiByteArrayOutputStream();
        IOUtils.copy(input, output);
        return output.toString();
    }

    public static String toString(@Nonnull InputStream input, int bufSize) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream(bufSize);
        IOUtils.copy(input, output);
        return output.toString();
    }

    @Nonnull
    public static byte[] toByteArray(@Nonnull InputStream input) throws IOException {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream();
        IOUtils.copy(input, output);
        return output.toByteArray();
    }

    public static int copy(@Nonnull InputStream input, @Nonnull OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    @Nonnull
    public static BufferedReader bufferedReader(@Nonnull InputStream is) {
        InputStreamReader in = new InputStreamReader(is);
        return new BufferedReader(in);
    }

    public static void writeInt(int v, OutputStream out) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeChar(char v, OutputStream out) throws IOException {
        out.write(0xFF & v >> 8);
        out.write(0xFF & v);
    }

    public static void writeChar(char v, FastByteArrayOutputStream out) {
        out.write(0xFF & v >> 8);
        out.write(0xFF & v);
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        return (char)(a << 8 | b & 0xFF);
    }

    public static void writeBytes(@Nonnull byte[] src, @Nonnull OutputStream dst) throws IOException {
        if (src != null) {
            dst.write(src);
        }
    }

    public static void writeBytes(@Nonnull byte[] src, int off, int len, @Nonnull OutputStream dst) throws IOException {
        if (src != null) {
            dst.write(src, off, len);
        }
    }

    public static void writeString(@Nullable String s, ObjectOutputStream out) throws IOException {
        IOUtils.writeString(s, (DataOutput)out);
    }

    public static void writeString(@Nullable String s, DataOutputStream out) throws IOException {
        IOUtils.writeString(s, (DataOutput)out);
    }

    public static void writeString(@Nullable String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeInt(-1);
            return;
        }
        int len = s.length();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            out.writeChar(v);
        }
    }

    public static void writeString(@Nullable String s, OutputStream out) throws IOException {
        if (s == null) {
            IOUtils.writeInt(-1, out);
            return;
        }
        int len = s.length();
        IOUtils.writeInt(len, out);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            IOUtils.writeChar(c, out);
        }
    }

    @Nullable
    public static String readString(@Nonnull ObjectInputStream in) throws IOException {
        return IOUtils.readString((DataInput)in);
    }

    @Nullable
    public static String readString(@Nonnull DataInputStream in) throws IOException {
        return IOUtils.readString((DataInput)in);
    }

    @Nullable
    public static String readString(@Nonnull DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        char[] ch = new char[len];
        for (int i = 0; i < len; ++i) {
            ch[i] = in.readChar();
        }
        return new String(ch);
    }

    @Nullable
    public static String readString(@Nonnull InputStream in) throws IOException {
        int len = IOUtils.readInt(in);
        if (len == -1) {
            return null;
        }
        char[] ch = new char[len];
        for (int i = 0; i < len; ++i) {
            ch[i] = IOUtils.readChar(in);
        }
        return new String(ch);
    }

    public static void writeFloats(@Nonnull float[] floats, @Nonnull DataOutput out) throws IOException {
        int size = floats.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeFloat(floats[i]);
        }
    }

    public static void writeFloats(@Nonnull float[] floats, int size, @Nonnull DataOutput out) throws IOException {
        for (int i = 0; i < size; ++i) {
            out.writeFloat(floats[i]);
        }
    }

    @Nonnull
    public static float[] readFloats(@Nonnull DataInput in) throws IOException {
        int size = in.readInt();
        float[] floats = new float[size];
        for (int i = 0; i < size; ++i) {
            floats[i] = in.readFloat();
        }
        return floats;
    }

    @Nonnull
    public static float[] readFloats(@Nonnull DataInput in, int size) throws IOException {
        float[] floats = new float[size];
        for (int i = 0; i < size; ++i) {
            floats[i] = in.readFloat();
        }
        return floats;
    }

    @Nonnull
    public static void readFloats(@Nonnull DataInput in, @Nonnull float[] dst) throws IOException {
        int len = dst.length;
        for (int i = 0; i < len; ++i) {
            dst[i] = in.readFloat();
        }
    }

    @Deprecated
    public static void writeVFloats(@Nonnull float[] floats, int size, @Nonnull DataOutput out) throws IOException {
        for (int i = 0; i < size; ++i) {
            int bits = Float.floatToIntBits(floats[i]);
            ZigZagLEB128Codec.writeSignedInt(bits, out);
        }
    }

    @Deprecated
    @Nonnull
    public static float[] readVFloats(@Nonnull DataInput in, int size) throws IOException {
        float[] floats = new float[size];
        for (int i = 0; i < size; ++i) {
            int bits = ZigZagLEB128Codec.readSignedInt(in);
            floats[i] = Float.intBitsToFloat(bits);
        }
        return floats;
    }

    public static void finishStream(@Nonnull OutputStream out) throws IOException {
        if (out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)out).finish();
        } else {
            out.flush();
        }
    }

    public static void readFully(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        do {
            if ((bytesRead = in.read(b, offset, len)) < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
        } while ((len -= bytesRead) != 0);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        IOUtils.readFully(in, b, 0, b.length);
    }
}

