/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.lang.NumberUtils;
import java.io.File;
import javax.annotation.Nonnull;

public final class FileUtils {
    private FileUtils() {
    }

    public static long getFileSize(@Nonnull File file) {
        if (!file.exists()) {
            return -1L;
        }
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    size += FileUtils.getFileSize(f);
                }
            }
        } else {
            size += file.length();
        }
        return size;
    }

    public static String prettyFileSize(@Nonnull File file) {
        return NumberUtils.prettySize(FileUtils.getFileSize(file));
    }
}

