/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import java.io.IOException;
import java.io.InputStream;

public final class FastByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int count;
    protected int pos = 0;

    public FastByteArrayInputStream() {
    }

    public FastByteArrayInputStream(byte[] buf) {
        this(buf, buf.length);
    }

    public FastByteArrayInputStream(byte[] buf, int count) {
        this.buf = buf;
        this.count = count;
    }

    public FastByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
    }

    public void init(byte[] buf) {
        this.init(buf, buf.length);
    }

    public void init(byte[] buf, int count) {
        this.buf = buf;
        this.count = count;
        this.pos = 0;
    }

    @Override
    public final int available() {
        return this.count - this.pos;
    }

    @Override
    public final int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public final long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
    }
}

