/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ASCII85OutputStream
extends FilterOutputStream {
    private static final long a85p2 = 7225L;
    private static final long a85p3 = 614125L;
    private static final long a85p4 = 52200625L;
    private static final byte TERMINATOR = 126;
    private static final byte OFFSET = 33;
    private static final byte Z = 122;
    private final byte[] indata = new byte[4];
    private final byte[] encoded = new byte[5];
    private int count = 0;
    private boolean flushed = true;

    public ASCII85OutputStream(OutputStream out) {
        super(out);
    }

    private void transformASCII85() {
        long word = (long)((this.indata[0] << 8 | this.indata[1] & 0xFF) << 16 | (this.indata[2] & 0xFF) << 8 | this.indata[3] & 0xFF) & 0xFFFFFFFFL;
        if (word == 0L) {
            this.encoded[0] = 122;
            this.encoded[1] = 0;
            return;
        }
        long x = word / 52200625L;
        this.encoded[0] = (byte)(x + 33L);
        word -= x * 52200625L;
        x = word / 614125L;
        this.encoded[1] = (byte)(x + 33L);
        word -= x * 614125L;
        x = word / 7225L;
        this.encoded[2] = (byte)(x + 33L);
        word -= x * 7225L;
        x = word / 85L;
        this.encoded[3] = (byte)(x + 33L);
        this.encoded[4] = (byte)(word % 85L + 33L);
    }

    @Override
    public void write(int b) throws IOException {
        this.flushed = false;
        this.indata[this.count++] = (byte)b;
        if (this.count < 4) {
            return;
        }
        this.transformASCII85();
        for (int i = 0; i < 5 && this.encoded[i] != 0; ++i) {
            this.out.write(this.encoded[i]);
        }
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.count > 0) {
            int i;
            for (i = this.count; i < 4; ++i) {
                this.indata[i] = 0;
            }
            this.transformASCII85();
            if (this.encoded[0] == 122) {
                for (i = 0; i < 5; ++i) {
                    this.encoded[i] = 33;
                }
            }
            for (i = 0; i < this.count + 1; ++i) {
                this.out.write(this.encoded[i]);
            }
        }
        this.out.write(126);
        this.count = 0;
        this.flushed = true;
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

