/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ASCII85InputStream
extends FilterInputStream {
    private static final byte TERMINATOR = 126;
    private static final byte OFFSET = 33;
    private static final byte NEWLINE = 10;
    private static final byte RETURN = 13;
    private static final byte SPACE = 32;
    private static final byte PADDING_U = 117;
    private static final byte Z = 122;
    private int index = 0;
    private int n = 0;
    private boolean eof = false;
    private final byte[] ascii = new byte[5];
    private final byte[] decoded = new byte[4];

    public ASCII85InputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        byte zz;
        byte z;
        if (this.index < this.n) {
            return this.decoded[this.index++] & 0xFF;
        }
        if (this.eof) {
            return -1;
        }
        this.index = 0;
        do {
            if ((zz = (byte)this.in.read()) != -1) continue;
            this.eof = true;
            return -1;
        } while ((z = (byte)zz) == 10 || z == 13 || z == 32);
        if (z == 126) {
            this.eof = true;
            this.n = 0;
            return -1;
        }
        if (z == 122) {
            this.decoded[3] = 0;
            this.decoded[2] = 0;
            this.decoded[1] = 0;
            this.decoded[0] = 0;
            this.n = 4;
        } else {
            int k;
            this.ascii[0] = z;
            for (k = 1; k < 5; ++k) {
                do {
                    if ((zz = (byte)this.in.read()) != -1) continue;
                    this.eof = true;
                    return -1;
                } while ((z = (byte)zz) == 10 || z == 13 || z == 32);
                this.ascii[k] = z;
                if (z != 126) continue;
                this.ascii[k] = 117;
                break;
            }
            this.n = k - 1;
            if (this.n == 0) {
                this.eof = true;
                return -1;
            }
            if (k < 5) {
                ++k;
                while (k < 5) {
                    this.ascii[k] = 117;
                    ++k;
                }
                this.eof = true;
            }
            long t = 0L;
            for (k = 0; k < 5; ++k) {
                z = (byte)(this.ascii[k] - 33);
                if (z < 0 || z > 93) {
                    throw new IOException("Invalid data in Ascii85 stream");
                }
                t = t * 85L + (long)z;
            }
            for (k = 3; k >= 0; --k) {
                this.decoded[k] = (byte)(t & 0xFFL);
                t >>>= 8;
            }
        }
        return this.decoded[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            if (this.index < this.n) {
                data[i + offset] = this.decoded[this.index++];
                continue;
            }
            int t = this.read();
            if (t == -1) {
                return i;
            }
            data[i + offset] = (byte)t;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.eof = true;
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long nValue) {
        return 0L;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Reset is not supported");
    }
}

