/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hadoop;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public final class HiveUtils {
    private HiveUtils() {
    }

    public static int parseInt(@Nonnull Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof IntWritable) {
            return ((IntWritable)o).get();
        }
        if (o instanceof LongWritable) {
            long l = ((LongWritable)o).get();
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("feature index must be less than 2147483647, but was " + l);
            }
            return (int)l;
        }
        String s = o.toString();
        return Integer.parseInt(s);
    }

    public static Text asText(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof LazyString) {
            LazyString l = (LazyString)o;
            return (Text)l.getWritableObject();
        }
        if (o instanceof String) {
            String s = (String)o;
            return new Text(s);
        }
        String s = o.toString();
        return new Text(s);
    }

    public static int asJavaInt(@Nullable Object o, int nullValue) {
        if (o == null) {
            return nullValue;
        }
        return HiveUtils.asJavaInt(o);
    }

    public static int asJavaInt(@Nullable Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof LazyInteger) {
            IntWritable i = (IntWritable)((LazyInteger)o).getWritableObject();
            return i.get();
        }
        if (o instanceof IntWritable) {
            return ((IntWritable)o).get();
        }
        String s = o.toString();
        return Integer.parseInt(s);
    }

    @Nullable
    public static List<String> asStringList(@Nonnull GenericUDF.DeferredObject arg, @Nonnull ListObjectInspector listOI) throws HiveException {
        Object argObj = arg.get();
        if (argObj == null) {
            return null;
        }
        List data = listOI.getList(argObj);
        int size = data.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        String[] ary = new String[size];
        for (int i = 0; i < size; ++i) {
            Object o = data.get(i);
            if (o == null) continue;
            ary[i] = o.toString();
        }
        return Arrays.asList(ary);
    }

    public static boolean isPrimitiveOI(@Nonnull ObjectInspector oi) {
        return oi.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    public static boolean isStringOI(@Nonnull ObjectInspector oi) {
        String typeName = oi.getTypeName();
        return "string".equals(typeName);
    }

    public static boolean isIntOI(@Nonnull ObjectInspector oi) {
        String typeName = oi.getTypeName();
        return "int".equals(typeName);
    }

    public static boolean isBigIntOI(@Nonnull ObjectInspector oi) {
        String typeName = oi.getTypeName();
        return "bigint".equals(typeName);
    }

    public static boolean isBooleanOI(@Nonnull ObjectInspector oi) {
        String typeName = oi.getTypeName();
        return "boolean".equals(typeName);
    }

    public static boolean isNumberOI(@Nonnull ObjectInspector argOI) throws UDFArgumentTypeException {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegerOI(@Nonnull ObjectInspector argOI) {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static boolean isListOI(@Nonnull ObjectInspector oi) {
        ObjectInspector.Category category = oi.getCategory();
        return category == ObjectInspector.Category.LIST;
    }

    public static boolean isPrimitiveTypeInfo(@Nonnull TypeInfo typeInfo) {
        return typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    public static boolean isNumberTypeInfo(@Nonnull TypeInfo typeInfo) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanTypeInfo(@Nonnull TypeInfo typeInfo) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegerTypeInfo(@Nonnull TypeInfo typeInfo) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstString(@Nonnull ObjectInspector oi) {
        return ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)oi) && HiveUtils.isStringOI(oi);
    }

    @Nonnull
    public static ListTypeInfo asListTypeInfo(@Nonnull TypeInfo typeInfo) throws UDFArgumentException {
        if (!typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentException("Expected list type: " + typeInfo);
        }
        return (ListTypeInfo)typeInfo;
    }

    @Nullable
    public static <T extends Writable> T getConstValue(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)oi)) {
            throw new UDFArgumentException("argument must be a constant value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        ConstantObjectInspector constOI = (ConstantObjectInspector)oi;
        Object v = constOI.getWritableConstantValue();
        return (T)((Writable)v);
    }

    @Nullable
    public static String[] getConstStringArray(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)oi)) {
            throw new UDFArgumentException("argument must be a constant value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        ConstantObjectInspector constOI = (ConstantObjectInspector)oi;
        if (constOI.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("argument must be an array: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        List lst = (List)constOI.getWritableConstantValue();
        if (lst == null) {
            return null;
        }
        int size = lst.size();
        String[] ary = new String[size];
        for (int i = 0; i < size; ++i) {
            Object o = lst.get(i);
            if (o == null) continue;
            ary[i] = o.toString();
        }
        return ary;
    }

    public static String getConstString(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!HiveUtils.isStringOI(oi)) {
            throw new UDFArgumentException("argument must be a Text value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        Text v = (Text)HiveUtils.getConstValue(oi);
        return v == null ? null : v.toString();
    }

    public static boolean getConstBoolean(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!HiveUtils.isBooleanOI(oi)) {
            throw new UDFArgumentException("argument must be a Boolean value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        BooleanWritable v = (BooleanWritable)HiveUtils.getConstValue(oi);
        return v.get();
    }

    public static int getConstInt(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!HiveUtils.isIntOI(oi)) {
            throw new UDFArgumentException("argument must be a Int value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        IntWritable v = (IntWritable)HiveUtils.getConstValue(oi);
        return v.get();
    }

    public static long getConstLong(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!HiveUtils.isBigIntOI(oi)) {
            throw new UDFArgumentException("argument must be a BigInt value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        LongWritable v = (LongWritable)HiveUtils.getConstValue(oi);
        return v.get();
    }

    public static int getAsConstInt(@Nonnull ObjectInspector numberOI) throws UDFArgumentException {
        String typeName = numberOI.getTypeName();
        if ("int".equals(typeName)) {
            IntWritable v = (IntWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("bigint".equals(typeName)) {
            LongWritable v = (LongWritable)HiveUtils.getConstValue(numberOI);
            return (int)v.get();
        }
        if ("smallint".equals(typeName)) {
            ShortWritable v = (ShortWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("tinyint".equals(typeName)) {
            ByteWritable v = (ByteWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        throw new UDFArgumentException("Unexpected argument type to cast as INT: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)numberOI));
    }

    public static long getAsConstLong(@Nonnull ObjectInspector numberOI) throws UDFArgumentException {
        String typeName = numberOI.getTypeName();
        if ("bigint".equals(typeName)) {
            LongWritable v = (LongWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("int".equals(typeName)) {
            IntWritable v = (IntWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("smallint".equals(typeName)) {
            ShortWritable v = (ShortWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("tinyint".equals(typeName)) {
            ByteWritable v = (ByteWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        throw new UDFArgumentException("Unexpected argument type to cast as long: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)numberOI));
    }

    public static float getAsConstFloat(@Nonnull ObjectInspector numberOI) throws UDFArgumentException {
        String typeName = numberOI.getTypeName();
        if ("float".equals(typeName)) {
            FloatWritable v = (FloatWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("double".equals(typeName)) {
            DoubleWritable v = (DoubleWritable)HiveUtils.getConstValue(numberOI);
            return (float)v.get();
        }
        if ("int".equals(typeName)) {
            IntWritable v = (IntWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("bigint".equals(typeName)) {
            LongWritable v = (LongWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("smallint".equals(typeName)) {
            ShortWritable v = (ShortWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("tinyint".equals(typeName)) {
            ByteWritable v = (ByteWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        throw new UDFArgumentException("Unexpected argument type to cast as double: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)numberOI));
    }

    public static double getAsConstDouble(@Nonnull ObjectInspector numberOI) throws UDFArgumentException {
        String typeName = numberOI.getTypeName();
        if ("double".equals(typeName)) {
            DoubleWritable v = (DoubleWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("float".equals(typeName)) {
            FloatWritable v = (FloatWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("int".equals(typeName)) {
            IntWritable v = (IntWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("bigint".equals(typeName)) {
            LongWritable v = (LongWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("smallint".equals(typeName)) {
            ShortWritable v = (ShortWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        if ("tinyint".equals(typeName)) {
            ByteWritable v = (ByteWritable)HiveUtils.getConstValue(numberOI);
            return v.get();
        }
        throw new UDFArgumentException("Unexpected argument type to cast as double: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)numberOI));
    }

    @Nonnull
    public static long[] asLongArray(@Nullable Object argObj, @Nonnull ListObjectInspector listOI, @Nonnull PrimitiveObjectInspector elemOI) {
        if (argObj == null) {
            return null;
        }
        int length = listOI.getListLength(argObj);
        long[] ary = new long[length];
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(argObj, i);
            if (o == null) continue;
            ary[i] = PrimitiveObjectInspectorUtils.getLong((Object)o, (PrimitiveObjectInspector)elemOI);
        }
        return ary;
    }

    @Nonnull
    public static long[] asLongArray(@Nullable Object argObj, @Nonnull ListObjectInspector listOI, @Nonnull LongObjectInspector elemOI) {
        if (argObj == null) {
            return null;
        }
        int length = listOI.getListLength(argObj);
        long[] ary = new long[length];
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(argObj, i);
            if (o == null) continue;
            ary[i] = elemOI.get(o);
        }
        return ary;
    }

    @Nonnull
    public static double[] asDoubleArray(@Nullable Object argObj, @Nonnull ListObjectInspector listOI, @Nonnull PrimitiveObjectInspector elemOI) {
        if (argObj == null) {
            return null;
        }
        int length = listOI.getListLength(argObj);
        double[] ary = new double[length];
        for (int i = 0; i < length; ++i) {
            double d;
            Object o = listOI.getListElement(argObj, i);
            if (o == null) continue;
            ary[i] = d = PrimitiveObjectInspectorUtils.getDouble((Object)o, (PrimitiveObjectInspector)elemOI);
        }
        return ary;
    }

    @Nonnull
    public static int setBits(@Nullable Object argObj, @Nonnull ListObjectInspector listOI, @Nonnull PrimitiveObjectInspector elemOI, @Nonnull BitSet bitset) throws UDFArgumentException {
        if (argObj == null) {
            return 0;
        }
        int count = 0;
        int length = listOI.getListLength(argObj);
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(argObj, i);
            if (o == null) continue;
            int index = PrimitiveObjectInspectorUtils.getInt((Object)o, (PrimitiveObjectInspector)elemOI);
            if (index < 0) {
                throw new UDFArgumentException("Negative index is not allowed: " + index);
            }
            bitset.set(index);
            ++count;
        }
        return count;
    }

    @Nonnull
    public static ConstantObjectInspector asConstantObjectInspector(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)oi)) {
            throw new UDFArgumentException("argument must be a constant value: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        return (ConstantObjectInspector)oi;
    }

    public static PrimitiveObjectInspector asPrimitiveObjectInspector(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        if (oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("Expecting PrimitiveObjectInspector: " + TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oi));
        }
        return (PrimitiveObjectInspector)oi;
    }

    public static StringObjectInspector asStringOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!"string".equals(argOI.getTypeName())) {
            throw new UDFArgumentException("Argument type must be String: " + argOI.getTypeName());
        }
        return (StringObjectInspector)argOI;
    }

    public static BinaryObjectInspector asBinaryOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!"binary".equals(argOI.getTypeName())) {
            throw new UDFArgumentException("Argument type must be Binary: " + argOI.getTypeName());
        }
        return (BinaryObjectInspector)argOI;
    }

    public static BooleanObjectInspector asBooleanOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!"boolean".equals(argOI.getTypeName())) {
            throw new UDFArgumentException("Argument type must be Boolean: " + argOI.getTypeName());
        }
        return (BooleanObjectInspector)argOI;
    }

    public static IntObjectInspector asIntOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!"int".equals(argOI.getTypeName())) {
            throw new UDFArgumentException("Argument type must be INT: " + argOI.getTypeName());
        }
        return (IntObjectInspector)argOI;
    }

    public static LongObjectInspector asLongOI(@Nonnull ObjectInspector argOI) throws UDFArgumentException {
        if (!"bigint".equals(argOI.getTypeName())) {
            throw new UDFArgumentException("Argument type must be BIGINT: " + argOI.getTypeName());
        }
        return (LongObjectInspector)argOI;
    }

    public static PrimitiveObjectInspector asIntCompatibleOI(@Nonnull ObjectInspector argOI) throws UDFArgumentTypeException {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + argOI.getTypeName() + " is passed.");
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case BOOLEAN: 
            case STRING: 
            case DECIMAL: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Unxpected type '" + argOI.getTypeName() + "' is passed.");
            }
        }
        return oi;
    }

    public static PrimitiveObjectInspector asLongCompatibleOI(@Nonnull ObjectInspector argOI) throws UDFArgumentTypeException {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + argOI.getTypeName() + " is passed.");
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case BOOLEAN: 
            case STRING: 
            case DECIMAL: 
            case TIMESTAMP: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Unxpected type '" + argOI.getTypeName() + "' is passed.");
            }
        }
        return oi;
    }

    public static PrimitiveObjectInspector asIntegerOI(@Nonnull ObjectInspector argOI) throws UDFArgumentTypeException {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + argOI.getTypeName() + " is passed.");
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case BYTE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Unxpected type '" + argOI.getTypeName() + "' is passed.");
            }
        }
        return oi;
    }

    public static PrimitiveObjectInspector asDoubleCompatibleOI(@Nonnull ObjectInspector argOI) throws UDFArgumentTypeException {
        if (argOI.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + argOI.getTypeName() + " is passed.");
        }
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)argOI;
        switch (oi.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case STRING: 
            case TIMESTAMP: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + argOI.getTypeName() + " is passed.");
            }
        }
        return oi;
    }

    @Nonnull
    public static ListObjectInspector asListOI(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        ObjectInspector.Category category = oi.getCategory();
        if (category != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("Expected List OI but was: " + oi);
        }
        return (ListObjectInspector)oi;
    }

    public static void validateFeatureOI(@Nonnull ObjectInspector oi) throws UDFArgumentException {
        String typeName = oi.getTypeName();
        if (!("string".equals(typeName) || "int".equals(typeName) || "bigint".equals(typeName))) {
            throw new UDFArgumentException("argument type for a feature must be List of key type [Int|BitInt|Text]: " + typeName);
        }
    }

    @Nonnull
    public static FloatWritable[] newFloatArray(int size, float defaultVal) {
        FloatWritable[] array = new FloatWritable[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new FloatWritable(defaultVal);
        }
        return array;
    }

    public static LazySimpleSerDe getKeyValueLineSerde(@Nonnull PrimitiveObjectInspector keyOI, @Nonnull PrimitiveObjectInspector valueOI) throws SerDeException {
        LazySimpleSerDe serde = new LazySimpleSerDe();
        Configuration conf = new Configuration();
        Properties tbl = new Properties();
        tbl.setProperty("columns", "key,value");
        tbl.setProperty("columns.types", keyOI.getTypeName() + "," + valueOI.getTypeName());
        serde.initialize(conf, tbl);
        return serde;
    }

    public static LazySimpleSerDe getLineSerde(PrimitiveObjectInspector ... OIs) throws SerDeException {
        if (OIs.length == 0) {
            throw new IllegalArgumentException("OIs must be specified");
        }
        LazySimpleSerDe serde = new LazySimpleSerDe();
        Configuration conf = new Configuration();
        Properties tbl = new Properties();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (int i = 0; i < OIs.length; ++i) {
            columnNames.append('c').append(i + 1).append(',');
            columnTypes.append(OIs[i].getTypeName()).append(',');
        }
        columnNames.deleteCharAt(columnNames.length() - 1);
        columnTypes.deleteCharAt(columnTypes.length() - 1);
        tbl.setProperty("columns", columnNames.toString());
        tbl.setProperty("columns.types", columnTypes.toString());
        serde.initialize(conf, tbl);
        return serde;
    }
}

