/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hadoop;

import hivemall.utils.lang.RandomUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.MapredContextAccessor;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskID;

public final class HadoopUtils {
    private HadoopUtils() {
    }

    public static BufferedReader getBufferedReader(File file) throws IOException {
        MapredContext context = MapredContextAccessor.get();
        return HadoopUtils.getBufferedReader(file, context);
    }

    public static BufferedReader getBufferedReader(File file, MapredContext context) throws IOException {
        URI fileuri = file.toURI();
        Path path = new Path(fileuri);
        JobConf conf = context.getJobConf();
        CompressionCodecFactory ccf = new CompressionCodecFactory((Configuration)conf);
        CompressionCodec codec = ccf.getCodec(path);
        if (codec == null) {
            return new BufferedReader(new FileReader(file));
        }
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        FileInputStream fis = new FileInputStream(file);
        CompressionInputStream cis = codec.createInputStream((InputStream)fis, decompressor);
        BufferedReaderExt br = new BufferedReaderExt((Reader)new InputStreamReader((InputStream)cis), decompressor);
        return br;
    }

    @Nonnull
    public static String getJobId() {
        MapredContext ctx = MapredContextAccessor.get();
        if (ctx == null) {
            throw new IllegalStateException("MapredContext is not set");
        }
        JobConf conf = ctx.getJobConf();
        if (conf == null) {
            throw new IllegalStateException("JobConf is not set");
        }
        String jobId = conf.get("mapred.job.id");
        if (jobId == null && (jobId = conf.get("mapreduce.job.id")) == null) {
            String queryId = conf.get("hive.query.id");
            if (queryId != null) {
                return queryId;
            }
            String taskidStr = conf.get("mapred.task.id");
            if (taskidStr == null) {
                throw new IllegalStateException("Cannot resolve jobId: " + HadoopUtils.toString(conf));
            }
            jobId = HadoopUtils.getJobIdFromTaskId(taskidStr);
        }
        return jobId;
    }

    @Nonnull
    public static String getJobIdFromTaskId(@Nonnull String taskidStr) {
        if (!taskidStr.startsWith("task_")) {
            taskidStr = taskidStr.replace("task", "task_");
            taskidStr = taskidStr.substring(0, taskidStr.lastIndexOf(95));
        }
        TaskID taskId = TaskID.forName((String)taskidStr);
        JobID jobId = taskId.getJobID();
        return jobId.toString();
    }

    public static int getTaskId() {
        MapredContext ctx = MapredContextAccessor.get();
        if (ctx == null) {
            throw new IllegalStateException("MapredContext is not set");
        }
        JobConf jobconf = ctx.getJobConf();
        if (jobconf == null) {
            throw new IllegalStateException("JobConf is not set");
        }
        int taskid = jobconf.getInt("mapred.task.partition", -1);
        if (taskid == -1 && (taskid = jobconf.getInt("mapreduce.task.partition", -1)) == -1) {
            throw new IllegalStateException("Both mapred.task.partition and mapreduce.task.partition are not set: " + HadoopUtils.toString(jobconf));
        }
        return taskid;
    }

    public static int getTaskId(int defaultValue) {
        MapredContext ctx = MapredContextAccessor.get();
        if (ctx == null) {
            return defaultValue;
        }
        JobConf jobconf = ctx.getJobConf();
        if (jobconf == null) {
            return defaultValue;
        }
        int taskid = jobconf.getInt("mapred.task.partition", -1);
        if (taskid == -1 && (taskid = jobconf.getInt("mapreduce.task.partition", -1)) == -1) {
            return defaultValue;
        }
        return taskid;
    }

    public static String getUniqueTaskIdString() {
        JobConf jobconf;
        MapredContext ctx = MapredContextAccessor.get();
        if (ctx != null && (jobconf = ctx.getJobConf()) != null) {
            int taskid = jobconf.getInt("mapred.task.partition", -1);
            if (taskid == -1) {
                taskid = jobconf.getInt("mapreduce.task.partition", -1);
            }
            if (taskid != -1) {
                return String.valueOf(taskid);
            }
        }
        return RandomUtils.getUUID();
    }

    @Nonnull
    public static String toString(@Nonnull JobConf jobconf) {
        return HadoopUtils.toString(jobconf, null);
    }

    @Nonnull
    public static String toString(@Nonnull JobConf jobconf, @Nullable String regexKey) {
        Iterator itor = jobconf.iterator();
        boolean hasNext = itor.hasNext();
        if (!hasNext) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1024);
        do {
            Map.Entry e = (Map.Entry)itor.next();
            hasNext = itor.hasNext();
            String k = (String)e.getKey();
            if (k == null || regexKey != null && !k.matches(regexKey)) continue;
            String v = (String)e.getValue();
            buf.append(k).append('=').append(v);
            if (!hasNext) continue;
            buf.append(',');
        } while (hasNext);
        return buf.toString();
    }

    private static final class BufferedReaderExt
    extends BufferedReader {
        private Decompressor decompressor;

        BufferedReaderExt(Reader in, Decompressor decompressor) {
            super(in);
            this.decompressor = decompressor;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }
}

