/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.datetime;

import hivemall.utils.datetime.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class StopWatch {
    private final String label;
    private long begin = 0L;
    private long end = 0L;
    private boolean showInSec = false;

    public StopWatch() {
        this(null, false);
    }

    public StopWatch(String label) {
        this(label, false);
    }

    public StopWatch(String label, boolean showInSec) {
        this.label = label;
        this.showInSec = showInSec;
        this.start();
    }

    public void setShowInSec(boolean showInSec) {
        this.showInSec = showInSec;
    }

    public void start() {
        this.begin = System.currentTimeMillis();
    }

    public long stop() {
        this.end = System.currentTimeMillis();
        return this.end - this.begin;
    }

    public void suspend() {
        this.end = System.currentTimeMillis();
    }

    public void resume() {
        this.begin += System.currentTimeMillis() - this.end;
    }

    public StopWatch reset() {
        this.begin = 0L;
        this.end = 0L;
        return this;
    }

    public long elapsed() {
        if (this.end != 0L) {
            return this.end - this.begin;
        }
        return System.currentTimeMillis() - this.begin;
    }

    public long elapsed(@Nonnull TimeUnit unit) {
        return unit.convert(this.elapsed(), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.label != null) {
            buf.append(this.label + ": ");
        }
        long t = this.elapsed();
        if (this.showInSec) {
            buf.append(DateTimeFormatter.formatTimeInSec(t));
            buf.append("sec");
        } else {
            buf.append(DateTimeFormatter.formatTime(t));
        }
        return buf.toString();
    }
}

