/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.collections.IntArray;
import hivemall.utils.lang.ArrayUtils;
import java.util.Arrays;

public final class SparseIntArray
implements IntArray {
    private static final long serialVersionUID = -2814248784231540118L;
    private int[] mKeys;
    private int[] mValues;
    private int mSize;

    public SparseIntArray() {
        this(10);
    }

    public SparseIntArray(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new int[initialCapacity];
        this.mSize = 0;
    }

    private SparseIntArray(int[] mKeys, int[] mValues, int mSize) {
        this.mKeys = mKeys;
        this.mValues = mValues;
        this.mSize = mSize;
    }

    public IntArray deepCopy() {
        int[] newKeys = new int[this.mSize];
        int[] newValues = new int[this.mSize];
        System.arraycopy(this.mKeys, 0, newKeys, 0, this.mSize);
        System.arraycopy(this.mValues, 0, newValues, 0, this.mSize);
        return new SparseIntArray(newKeys, newValues, this.mSize);
    }

    @Override
    public int get(int key) {
        return this.get(key, 0);
    }

    @Override
    public int get(int key, int valueIfKeyNotFound) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    @Override
    public void put(int key, int value) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = ArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = ArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public void increment(int key, int value) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            int n = i;
            this.mValues[n] = this.mValues[n] + value;
        } else {
            this.mKeys = ArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = ArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public int valueAt(int index) {
        return this.mValues[index];
    }

    public void setValueAt(int index, int value) {
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        return Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(int value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, int value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = ArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = ArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            int value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

