/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.collections.IMapIterator;
import hivemall.utils.lang.Copyable;
import hivemall.utils.math.Primes;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class OpenHashTable<K, V>
implements Externalizable {
    public static final float DEFAULT_LOAD_FACTOR = 0.7f;
    public static final float DEFAULT_GROW_FACTOR = 2.0f;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected float _loadFactor;
    protected float _growFactor;
    protected int _used = 0;
    protected int _threshold;
    protected K[] _keys;
    protected V[] _values;
    protected byte[] _states;

    public OpenHashTable() {
    }

    public OpenHashTable(int size) {
        this(size, 0.7f, 2.0f);
    }

    public OpenHashTable(int size, float loadFactor, float growFactor) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this._loadFactor = loadFactor;
        this._growFactor = growFactor;
        int actualSize = Primes.findLeastPrimeNumber(size);
        this._keys = new Object[actualSize];
        this._values = new Object[actualSize];
        this._states = new byte[actualSize];
        this._threshold = Math.round((float)actualSize * this._loadFactor);
    }

    public OpenHashTable(@Nonnull K[] keys, @Nonnull V[] values, @Nonnull byte[] states, int used) {
        this._used = used;
        this._threshold = keys.length;
        this._keys = keys;
        this._values = values;
        this._states = states;
    }

    public Object[] getKeys() {
        return this._keys;
    }

    public Object[] getValues() {
        return this._values;
    }

    public byte[] getStates() {
        return this._states;
    }

    public boolean containsKey(K key) {
        return this.findKey(key) >= 0;
    }

    public V get(K key) {
        int i = this.findKey(key);
        if (i < 0) {
            return null;
        }
        return this._values[i];
    }

    public V put(K key, V value) {
        block5: {
            int keyLength;
            int hash = OpenHashTable.keyHash(key);
            int keyIdx = hash % (keyLength = this._keys.length);
            boolean expanded = this.preAddEntry(keyIdx);
            if (expanded) {
                keyLength = this._keys.length;
                keyIdx = hash % keyLength;
            }
            K[] keys = this._keys;
            V[] values = this._values;
            byte[] states = this._states;
            if (states[keyIdx] == 1) {
                if (OpenHashTable.equals(keys[keyIdx], key)) {
                    V old = values[keyIdx];
                    values[keyIdx] = value;
                    return old;
                }
                int decr = 1 + hash % (keyLength - 2);
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += keyLength;
                    }
                    if (this.isFree(keyIdx, key)) break block5;
                } while (states[keyIdx] != 1 || !OpenHashTable.equals(keys[keyIdx], key));
                V old = values[keyIdx];
                values[keyIdx] = value;
                return old;
            }
        }
        keys[keyIdx] = key;
        values[keyIdx] = value;
        states[keyIdx] = 1;
        ++this._used;
        return null;
    }

    private static boolean equals(Object k1, Object k2) {
        return k1 == k2 || k1.equals(k2);
    }

    protected boolean isFree(int index, K key) {
        byte stat = this._states[index];
        if (stat == 0) {
            return true;
        }
        return stat == 2 && OpenHashTable.equals(this._keys[index], key);
    }

    protected boolean preAddEntry(int index) {
        if (this._used + 1 >= this._threshold) {
            int newCapacity = Math.round((float)this._keys.length * this._growFactor);
            this.ensureCapacity(newCapacity);
            return true;
        }
        return false;
    }

    protected int findKey(K key) {
        K[] keys = this._keys;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = OpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && OpenHashTable.equals(keys[keyIdx], key)) {
                return keyIdx;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (!this.isFree(keyIdx, key)) continue;
                return -1;
            } while (states[keyIdx] != 1 || !OpenHashTable.equals(keys[keyIdx], key));
            return keyIdx;
        }
        return -1;
    }

    public V remove(K key) {
        K[] keys = this._keys;
        V[] values = this._values;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = OpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && OpenHashTable.equals(keys[keyIdx], key)) {
                V old = values[keyIdx];
                states[keyIdx] = 2;
                --this._used;
                return old;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (states[keyIdx] != 0) continue;
                return null;
            } while (states[keyIdx] != 1 || !OpenHashTable.equals(keys[keyIdx], key));
            V old = values[keyIdx];
            states[keyIdx] = 2;
            --this._used;
            return old;
        }
        return null;
    }

    public int size() {
        return this._used;
    }

    public void clear() {
        Arrays.fill(this._states, (byte)0);
        this._used = 0;
    }

    public IMapIterator<K, V> entries() {
        return new MapIterator();
    }

    public String toString() {
        int len = this.size() * 10 + 2;
        StringBuilder buf = new StringBuilder(len);
        buf.append('{');
        IMapIterator<K, V> i = this.entries();
        while (i.next() != -1) {
            String key = i.getKey().toString();
            buf.append(key);
            buf.append('=');
            buf.append(i.getValue());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append('}');
        return buf.toString();
    }

    protected void ensureCapacity(int newCapacity) {
        int prime = Primes.findLeastPrimeNumber(newCapacity);
        this.rehash(prime);
        this._threshold = Math.round((float)prime * this._loadFactor);
    }

    private void rehash(int newCapacity) {
        int oldCapacity = this._keys.length;
        if (newCapacity <= oldCapacity) {
            throw new IllegalArgumentException("new: " + newCapacity + ", old: " + oldCapacity);
        }
        Object[] newkeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        byte[] newStates = new byte[newCapacity];
        int used = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (this._states[i] != 1) continue;
            ++used;
            K k = this._keys[i];
            V v = this._values[i];
            int hash = OpenHashTable.keyHash(k);
            int keyIdx = hash % newCapacity;
            if (newStates[keyIdx] == 1) {
                int decr = 1 + hash % (newCapacity - 2);
                while (newStates[keyIdx] != 0) {
                    if ((keyIdx -= decr) >= 0) continue;
                    keyIdx += newCapacity;
                }
            }
            newStates[keyIdx] = 1;
            newkeys[keyIdx] = k;
            newValues[keyIdx] = v;
        }
        this._keys = newkeys;
        this._values = newValues;
        this._states = newStates;
        this._used = used;
    }

    private static int keyHash(Object key) {
        int hash = key.hashCode();
        return hash & Integer.MAX_VALUE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this._loadFactor);
        out.writeFloat(this._growFactor);
        out.writeInt(this._used);
        int size = this._keys.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this._keys[i]);
            out.writeObject(this._values[i]);
            out.writeByte(this._states[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._loadFactor = in.readFloat();
        this._growFactor = in.readFloat();
        this._used = in.readInt();
        int size = in.readInt();
        Object[] keys = new Object[size];
        Object[] values = new Object[size];
        byte[] states = new byte[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = in.readObject();
            values[i] = in.readObject();
            states[i] = in.readByte();
        }
        this._threshold = size;
        this._keys = keys;
        this._values = values;
        this._states = states;
    }

    private final class MapIterator
    implements IMapIterator<K, V> {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        MapIterator() {
        }

        int nextEntry(int index) {
            while (index < OpenHashTable.this._keys.length && OpenHashTable.this._states[index] != 1) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < OpenHashTable.this._keys.length;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                return -1;
            }
            int curEntry = this.nextEntry;
            this.lastEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(this.nextEntry + 1);
            return curEntry;
        }

        @Override
        public K getKey() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return OpenHashTable.this._keys[this.lastEntry];
        }

        @Override
        public V getValue() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return OpenHashTable.this._values[this.lastEntry];
        }

        @Override
        public <T extends Copyable<V>> void getValue(T probe) {
            probe.copyFrom(this.getValue());
        }
    }
}

