/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.collections.IMapIterator;
import hivemall.utils.lang.Copyable;
import hivemall.utils.math.MathUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class OpenHashMap<K, V>
implements Map<K, V>,
Externalizable {
    private K[] keys;
    private V[] values;
    private int size;
    private int bits;
    private int sweepbits;
    private int sweep;
    private int sweepmask;

    public OpenHashMap() {
    }

    public OpenHashMap(int size) {
        this.resize(MathUtils.bitsRequired(size < 256 ? 256 : size));
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " key");
        }
        while (true) {
            int off;
            int end = off + this.sweep;
            for (off = this.getBucketOffset(key); off < end; ++off) {
                K searchKey = this.keys[off];
                if (searchKey == null) {
                    this.keys[off] = key;
                    ++this.size;
                    V previous = this.values[off];
                    this.values[off] = value;
                    return previous;
                }
                if (!OpenHashMap.compare(searchKey, key)) continue;
                V previous = this.values[off];
                this.values[off] = value;
                return previous;
            }
            this.resize(this.bits + 1);
        }
    }

    @Override
    public V get(Object key) {
        int off;
        int end = this.sweep + off;
        for (off = this.getBucketOffset(key); off < end; ++off) {
            if (this.keys[off] == null || !OpenHashMap.compare(this.keys[off], key)) continue;
            return this.values[off];
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        int off;
        int end = this.sweep + off;
        for (off = this.getBucketOffset(key); off < end; ++off) {
            if (this.keys[off] == null || !OpenHashMap.compare(this.keys[off], key)) continue;
            this.keys[off] = null;
            V previous = this.values[off];
            this.values[off] = null;
            --this.size;
            return previous;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values) {
            if (v == null || !OpenHashMap.compare(v, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> set = new HashSet<K>();
        for (K key : this.keys) {
            if (key == null) continue;
            set.add(key);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (V value : this.values) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keys) {
            if (key == null) continue;
            set.add(new MapEntry(this, key));
        }
        return set;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.bits);
        out.writeInt(this.size);
        for (int x = 0; x < this.keys.length; ++x) {
            if (this.keys[x] == null) continue;
            out.writeObject(this.keys[x]);
            out.writeObject(this.values[x]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int bitSize = in.readInt();
        if (bitSize != this.bits) {
            this.resize(bitSize);
        }
        int size = in.readInt();
        for (int x = 0; x < size; ++x) {
            this.put(in.readObject(), in.readObject());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.size;
    }

    private void resize(int bits) {
        this.bits = bits;
        this.sweepbits = bits / 4;
        this.sweep = MathUtils.powerOf(2, this.sweepbits) * 4;
        this.sweepmask = MathUtils.bitMask(bits - this.sweepbits) << this.sweepbits;
        K[] existingKeys = this.keys;
        V[] existingValues = this.values;
        this.values = new Object[MathUtils.powerOf(2, bits) + this.sweep];
        this.keys = new Object[this.values.length];
        this.size = 0;
        if (existingKeys != null) {
            for (int x = 0; x < existingKeys.length; ++x) {
                if (existingKeys[x] == null) continue;
                this.put(existingKeys[x], existingValues[x]);
            }
        }
    }

    private int getBucketOffset(Object key) {
        return key.hashCode() << this.sweepbits & this.sweepmask;
    }

    private static boolean compare(Object v1, Object v2) {
        return v1 == v2 || v1.equals(v2);
    }

    public IMapIterator<K, V> entries() {
        return new MapIterator();
    }

    private final class MapIterator
    implements IMapIterator<K, V> {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        MapIterator() {
        }

        int nextEntry(int index) {
            while (index < OpenHashMap.this.keys.length && OpenHashMap.this.keys[index] == null) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < OpenHashMap.this.keys.length;
        }

        @Override
        public int next() {
            int curEntry;
            this.free(this.lastEntry);
            if (!this.hasNext()) {
                return -1;
            }
            this.lastEntry = curEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(curEntry + 1);
            return curEntry;
        }

        @Override
        public K getKey() {
            return OpenHashMap.this.keys[this.lastEntry];
        }

        @Override
        public V getValue() {
            return OpenHashMap.this.values[this.lastEntry];
        }

        @Override
        public <T extends Copyable<V>> void getValue(T probe) {
            probe.copyFrom(this.getValue());
        }

        private void free(int index) {
            if (index >= 0) {
                ((OpenHashMap)OpenHashMap.this).keys[index] = null;
                ((OpenHashMap)OpenHashMap.this).values[index] = null;
            }
        }
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map<K, V> map;
        private final K key;

        public MapEntry(Map<K, V> map, K key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.map.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return this.map.put(this.key, value);
        }
    }
}

