/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -7708264099645977733L;
    private final int cacheSize;

    public LRUMap(int cacheSize) {
        this(cacheSize, 0.75f, cacheSize);
    }

    public LRUMap(int capacity, float loadFactor, int cacheSize) {
        super(capacity, loadFactor, true);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }
}

