/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.lang.ArrayUtils;
import java.io.Serializable;

public final class IntArrayList
implements Serializable {
    private static final long serialVersionUID = -2147675120406747488L;
    public static final int DEFAULT_CAPACITY = 12;
    private int[] data;
    private int used;

    public IntArrayList() {
        this(12);
    }

    public IntArrayList(int size) {
        this.data = new int[size];
        this.used = 0;
    }

    public IntArrayList(int[] initValues) {
        this.data = initValues;
        this.used = initValues.length;
    }

    public void add(int value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
    }

    public void add(int[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
    }

    private void expand(int max) {
        while (this.data.length < max) {
            int len = this.data.length;
            int[] newArray = new int[len * 2];
            System.arraycopy(this.data, 0, newArray, 0, len);
            this.data = newArray;
        }
    }

    public int remove() {
        return this.data[--this.used];
    }

    public int remove(int index) {
        int ret;
        if (index > this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[--this.used];
        } else {
            ret = this.data[index];
            int[] newarray = new int[--this.used];
            System.arraycopy(this.data, 0, newarray, 0, index - 1);
            System.arraycopy(this.data, index + 1, newarray, index, this.used - index);
            this.data = newarray;
        }
        return ret;
    }

    public void set(int index, int value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index " + index + " MUST be less than size() " + this.used);
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public int get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds " + this.used);
        }
        return this.data[index];
    }

    public int fastGet(int index) {
        return this.data[index];
    }

    public int indexOf(int key) {
        return ArrayUtils.indexOf(this.data, key, 0, this.used);
    }

    public boolean contains(int key) {
        return ArrayUtils.indexOf(this.data, key, 0, this.used) != -1;
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    public int[] toArray() {
        int[] newArray = new int[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        return newArray;
    }

    public int[] array() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

