/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.codec.VariableByteCodec;
import hivemall.utils.codec.ZigZagLEB128Codec;
import hivemall.utils.math.Primes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class Int2LongOpenHashTable
implements Externalizable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    public static final int DEFAULT_SIZE = 65536;
    public static final float DEFAULT_LOAD_FACTOR = 0.7f;
    public static final float DEFAULT_GROW_FACTOR = 2.0f;
    protected final transient float _loadFactor;
    protected final transient float _growFactor;
    protected int[] _keys;
    protected long[] _values;
    protected byte[] _states;
    protected int _used;
    protected int _threshold;
    protected long defaultReturnValue = -1L;

    public Int2LongOpenHashTable() {
        this._loadFactor = 0.7f;
        this._growFactor = 2.0f;
    }

    public Int2LongOpenHashTable(int size) {
        this(size, 0.7f, 2.0f, true);
    }

    public Int2LongOpenHashTable(int size, float loadFactor, float growFactor) {
        this(size, loadFactor, growFactor, true);
    }

    protected Int2LongOpenHashTable(int size, float loadFactor, float growFactor, boolean forcePrime) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this._loadFactor = loadFactor;
        this._growFactor = growFactor;
        int actualSize = forcePrime ? Primes.findLeastPrimeNumber(size) : size;
        this._keys = new int[actualSize];
        this._values = new long[actualSize];
        this._states = new byte[actualSize];
        this._used = 0;
        this._threshold = (int)((float)actualSize * this._loadFactor);
    }

    public Int2LongOpenHashTable(@Nonnull int[] keys, @Nonnull long[] values, @Nonnull byte[] states, int used) {
        this._loadFactor = 0.7f;
        this._growFactor = 2.0f;
        this._keys = keys;
        this._values = values;
        this._states = states;
        this._used = used;
        this._threshold = keys.length;
    }

    @Nonnull
    public static Int2LongOpenHashTable newInstance() {
        return new Int2LongOpenHashTable(65536);
    }

    public void defaultReturnValue(long v) {
        this.defaultReturnValue = v;
    }

    @Nonnull
    public int[] getKeys() {
        return this._keys;
    }

    @Nonnull
    public long[] getValues() {
        return this._values;
    }

    @Nonnull
    public byte[] getStates() {
        return this._states;
    }

    public boolean containsKey(int key) {
        return this.findKey(key) >= 0;
    }

    public long get(int key) {
        int i = this.findKey(key);
        if (i < 0) {
            return this.defaultReturnValue;
        }
        return this._values[i];
    }

    public long put(int key, long value) {
        block5: {
            int keyLength;
            int hash = Int2LongOpenHashTable.keyHash(key);
            int keyIdx = hash % (keyLength = this._keys.length);
            boolean expanded = this.preAddEntry(keyIdx);
            if (expanded) {
                keyLength = this._keys.length;
                keyIdx = hash % keyLength;
            }
            int[] keys = this._keys;
            long[] values = this._values;
            byte[] states = this._states;
            if (states[keyIdx] == 1) {
                if (keys[keyIdx] == key) {
                    long old = values[keyIdx];
                    values[keyIdx] = value;
                    return old;
                }
                int decr = 1 + hash % (keyLength - 2);
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += keyLength;
                    }
                    if (this.isFree(keyIdx, key)) break block5;
                } while (states[keyIdx] != 1 || keys[keyIdx] != key);
                long old = values[keyIdx];
                values[keyIdx] = value;
                return old;
            }
        }
        keys[keyIdx] = key;
        values[keyIdx] = value;
        states[keyIdx] = 1;
        ++this._used;
        return this.defaultReturnValue;
    }

    protected boolean isFree(int index, int key) {
        byte stat = this._states[index];
        if (stat == 0) {
            return true;
        }
        return stat == 2 && this._keys[index] == key;
    }

    protected boolean preAddEntry(int index) {
        if (this._used + 1 >= this._threshold) {
            int newCapacity = Math.round((float)this._keys.length * this._growFactor);
            this.ensureCapacity(newCapacity);
            return true;
        }
        return false;
    }

    protected int findKey(int key) {
        int[] keys = this._keys;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = Int2LongOpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && keys[keyIdx] == key) {
                return keyIdx;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (!this.isFree(keyIdx, key)) continue;
                return -1;
            } while (states[keyIdx] != 1 || keys[keyIdx] != key);
            return keyIdx;
        }
        return -1;
    }

    public long remove(int key) {
        int[] keys = this._keys;
        long[] values = this._values;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = Int2LongOpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && keys[keyIdx] == key) {
                long old = values[keyIdx];
                states[keyIdx] = 2;
                --this._used;
                return old;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (states[keyIdx] != 0) continue;
                return this.defaultReturnValue;
            } while (states[keyIdx] != 1 || keys[keyIdx] != key);
            long old = values[keyIdx];
            states[keyIdx] = 2;
            --this._used;
            return old;
        }
        return this.defaultReturnValue;
    }

    public int size() {
        return this._used;
    }

    public int capacity() {
        return this._keys.length;
    }

    public void clear() {
        Arrays.fill(this._states, (byte)0);
        this._used = 0;
    }

    public IMapIterator entries() {
        return new MapIterator();
    }

    public String toString() {
        int len = this.size() * 10 + 2;
        StringBuilder buf = new StringBuilder(len);
        buf.append('{');
        IMapIterator i = this.entries();
        while (i.next() != -1) {
            buf.append(i.getKey());
            buf.append('=');
            buf.append(i.getValue());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append('}');
        return buf.toString();
    }

    protected void ensureCapacity(int newCapacity) {
        int prime = Primes.findLeastPrimeNumber(newCapacity);
        this.rehash(prime);
        this._threshold = Math.round((float)prime * this._loadFactor);
    }

    private void rehash(int newCapacity) {
        int oldCapacity = this._keys.length;
        if (newCapacity <= oldCapacity) {
            throw new IllegalArgumentException("new: " + newCapacity + ", old: " + oldCapacity);
        }
        int[] newkeys = new int[newCapacity];
        long[] newValues = new long[newCapacity];
        byte[] newStates = new byte[newCapacity];
        int used = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (this._states[i] != 1) continue;
            ++used;
            int k = this._keys[i];
            long v = this._values[i];
            int hash = Int2LongOpenHashTable.keyHash(k);
            int keyIdx = hash % newCapacity;
            if (newStates[keyIdx] == 1) {
                int decr = 1 + hash % (newCapacity - 2);
                while (newStates[keyIdx] != 0) {
                    if ((keyIdx -= decr) >= 0) continue;
                    keyIdx += newCapacity;
                }
            }
            newkeys[keyIdx] = k;
            newValues[keyIdx] = v;
            newStates[keyIdx] = 1;
        }
        this._keys = newkeys;
        this._values = newValues;
        this._states = newStates;
        this._used = used;
    }

    private static int keyHash(int key) {
        return key & Integer.MAX_VALUE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._threshold);
        out.writeInt(this._used);
        int[] keys = this._keys;
        int size = keys.length;
        out.writeInt(size);
        byte[] states = this._states;
        Int2LongOpenHashTable.writeStates(states, out);
        long[] values = this._values;
        for (int i = 0; i < size; ++i) {
            if (states[i] != 1) continue;
            ZigZagLEB128Codec.writeSignedInt(keys[i], out);
            ZigZagLEB128Codec.writeSignedLong(values[i], out);
        }
    }

    @Nonnull
    private static void writeStates(@Nonnull byte[] status, @Nonnull DataOutput out) throws IOException {
        int size = status.length;
        int cardinarity = 0;
        for (int i = 0; i < size; ++i) {
            if (status[i] == 1) continue;
            ++cardinarity;
        }
        out.writeInt(cardinarity);
        if (cardinarity == 0) {
            return;
        }
        int prev = 0;
        for (int i = 0; i < size; ++i) {
            if (status[i] == 1) continue;
            int diff = i - prev;
            assert (diff >= 0);
            VariableByteCodec.encodeUnsignedInt(diff, out);
            prev = i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._threshold = in.readInt();
        this._used = in.readInt();
        int size = in.readInt();
        int[] keys = new int[size];
        long[] values = new long[size];
        byte[] states = new byte[size];
        Int2LongOpenHashTable.readStates(in, states);
        for (int i = 0; i < size; ++i) {
            if (states[i] != 1) continue;
            keys[i] = ZigZagLEB128Codec.readSignedInt(in);
            values[i] = ZigZagLEB128Codec.readSignedLong(in);
        }
        this._keys = keys;
        this._values = values;
        this._states = states;
    }

    @Nonnull
    private static void readStates(@Nonnull DataInput in, @Nonnull byte[] status) throws IOException {
        int cardinarity = in.readInt();
        Arrays.fill(status, (byte)1);
        int prev = 0;
        for (int j = 0; j < cardinarity; ++j) {
            int i = VariableByteCodec.decodeUnsignedInt(in) + prev;
            status[i] = 0;
            prev = i;
        }
    }

    private final class MapIterator
    implements IMapIterator {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        MapIterator() {
        }

        int nextEntry(int index) {
            while (index < Int2LongOpenHashTable.this._keys.length && Int2LongOpenHashTable.this._states[index] != 1) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < Int2LongOpenHashTable.this._keys.length;
        }

        @Override
        public int next() {
            int curEntry;
            if (!this.hasNext()) {
                return -1;
            }
            this.lastEntry = curEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(curEntry + 1);
            return curEntry;
        }

        @Override
        public int getKey() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Int2LongOpenHashTable.this._keys[this.lastEntry];
        }

        @Override
        public long getValue() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Int2LongOpenHashTable.this._values[this.lastEntry];
        }
    }

    public static interface IMapIterator {
        public boolean hasNext();

        public int next();

        public int getKey();

        public long getValue();
    }
}

