/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.math.Primes;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public final class Int2IntOpenHashTable
implements Externalizable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final float DEFAULT_LOAD_FACTOR = 0.7f;
    private static final float DEFAULT_GROW_FACTOR = 2.0f;
    protected final transient float _loadFactor;
    protected final transient float _growFactor;
    protected int _used = 0;
    protected int _threshold;
    protected int defaultReturnValue = -1;
    protected int[] _keys;
    protected int[] _values;
    protected byte[] _states;

    protected Int2IntOpenHashTable(int size, float loadFactor, float growFactor, boolean forcePrime) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this._loadFactor = loadFactor;
        this._growFactor = growFactor;
        int actualSize = forcePrime ? Primes.findLeastPrimeNumber(size) : size;
        this._keys = new int[actualSize];
        this._values = new int[actualSize];
        this._states = new byte[actualSize];
        this._threshold = (int)((float)actualSize * this._loadFactor);
    }

    public Int2IntOpenHashTable(int size, int loadFactor, int growFactor) {
        this(size, loadFactor, growFactor, true);
    }

    public Int2IntOpenHashTable(int size) {
        this(size, 0.7f, 2.0f, true);
    }

    public Int2IntOpenHashTable() {
        this._loadFactor = 0.7f;
        this._growFactor = 2.0f;
    }

    public void defaultReturnValue(int v) {
        this.defaultReturnValue = v;
    }

    public boolean containsKey(int key) {
        return this.findKey(key) >= 0;
    }

    public int get(int key) {
        int i = this.findKey(key);
        if (i < 0) {
            return this.defaultReturnValue;
        }
        return this._values[i];
    }

    public int put(int key, int value) {
        block5: {
            int keyLength;
            int hash = Int2IntOpenHashTable.keyHash(key);
            int keyIdx = hash % (keyLength = this._keys.length);
            boolean expanded = this.preAddEntry(keyIdx);
            if (expanded) {
                keyLength = this._keys.length;
                keyIdx = hash % keyLength;
            }
            int[] keys = this._keys;
            int[] values = this._values;
            byte[] states = this._states;
            if (states[keyIdx] == 1) {
                if (keys[keyIdx] == key) {
                    int old = values[keyIdx];
                    values[keyIdx] = value;
                    return old;
                }
                int decr = 1 + hash % (keyLength - 2);
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += keyLength;
                    }
                    if (this.isFree(keyIdx, key)) break block5;
                } while (states[keyIdx] != 1 || keys[keyIdx] != key);
                int old = values[keyIdx];
                values[keyIdx] = value;
                return old;
            }
        }
        keys[keyIdx] = key;
        values[keyIdx] = value;
        states[keyIdx] = 1;
        ++this._used;
        return this.defaultReturnValue;
    }

    protected boolean isFree(int index, int key) {
        byte stat = this._states[index];
        if (stat == 0) {
            return true;
        }
        return stat == 2 && this._keys[index] == key;
    }

    protected boolean preAddEntry(int index) {
        if (this._used + 1 >= this._threshold) {
            int newCapacity = Math.round((float)this._keys.length * this._growFactor);
            this.ensureCapacity(newCapacity);
            return true;
        }
        return false;
    }

    protected int findKey(int key) {
        int[] keys = this._keys;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = Int2IntOpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && keys[keyIdx] == key) {
                return keyIdx;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (!this.isFree(keyIdx, key)) continue;
                return -1;
            } while (states[keyIdx] != 1 || keys[keyIdx] != key);
            return keyIdx;
        }
        return -1;
    }

    public int remove(int key) {
        int[] keys = this._keys;
        int[] values = this._values;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = Int2IntOpenHashTable.keyHash(key);
        int keyIdx = hash % keyLength;
        if (states[keyIdx] != 0) {
            if (states[keyIdx] == 1 && keys[keyIdx] == key) {
                int old = values[keyIdx];
                states[keyIdx] = 2;
                --this._used;
                return old;
            }
            int decr = 1 + hash % (keyLength - 2);
            do {
                if ((keyIdx -= decr) < 0) {
                    keyIdx += keyLength;
                }
                if (states[keyIdx] != 0) continue;
                return this.defaultReturnValue;
            } while (states[keyIdx] != 1 || keys[keyIdx] != key);
            int old = values[keyIdx];
            states[keyIdx] = 2;
            --this._used;
            return old;
        }
        return this.defaultReturnValue;
    }

    public int size() {
        return this._used;
    }

    public void clear() {
        Arrays.fill(this._states, (byte)0);
        this._used = 0;
    }

    public IMapIterator entries() {
        return new MapIterator();
    }

    public String toString() {
        int len = this.size() * 10 + 2;
        StringBuilder buf = new StringBuilder(len);
        buf.append('{');
        IMapIterator i = this.entries();
        while (i.next() != -1) {
            buf.append(i.getKey());
            buf.append('=');
            buf.append(i.getValue());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append('}');
        return buf.toString();
    }

    protected void ensureCapacity(int newCapacity) {
        int prime = Primes.findLeastPrimeNumber(newCapacity);
        this.rehash(prime);
        this._threshold = Math.round((float)prime * this._loadFactor);
    }

    private void rehash(int newCapacity) {
        int oldCapacity = this._keys.length;
        if (newCapacity <= oldCapacity) {
            throw new IllegalArgumentException("new: " + newCapacity + ", old: " + oldCapacity);
        }
        int[] newkeys = new int[newCapacity];
        int[] newValues = new int[newCapacity];
        byte[] newStates = new byte[newCapacity];
        int used = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (this._states[i] != 1) continue;
            ++used;
            int k = this._keys[i];
            int v = this._values[i];
            int hash = Int2IntOpenHashTable.keyHash(k);
            int keyIdx = hash % newCapacity;
            if (newStates[keyIdx] == 1) {
                int decr = 1 + hash % (newCapacity - 2);
                while (newStates[keyIdx] != 0) {
                    if ((keyIdx -= decr) >= 0) continue;
                    keyIdx += newCapacity;
                }
            }
            newkeys[keyIdx] = k;
            newValues[keyIdx] = v;
            newStates[keyIdx] = 1;
        }
        this._keys = newkeys;
        this._values = newValues;
        this._states = newStates;
        this._used = used;
    }

    private static int keyHash(int key) {
        return key & Integer.MAX_VALUE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._threshold);
        out.writeInt(this._used);
        out.writeInt(this._keys.length);
        IMapIterator i = this.entries();
        while (i.next() != -1) {
            out.writeInt(i.getKey());
            out.writeInt(i.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._threshold = in.readInt();
        this._used = in.readInt();
        int keylen = in.readInt();
        int[] keys = new int[keylen];
        int[] values = new int[keylen];
        byte[] states = new byte[keylen];
        for (int i = 0; i < this._used; ++i) {
            int k = in.readInt();
            int v = in.readInt();
            int hash = Int2IntOpenHashTable.keyHash(k);
            int keyIdx = hash % keylen;
            if (states[keyIdx] != 0) {
                int decr = 1 + hash % (keylen - 2);
                do {
                    if ((keyIdx -= decr) >= 0) continue;
                    keyIdx += keylen;
                } while (states[keyIdx] != 0);
            }
            states[keyIdx] = 1;
            keys[keyIdx] = k;
            values[keyIdx] = v;
        }
        this._keys = keys;
        this._values = values;
        this._states = states;
    }

    private final class MapIterator
    implements IMapIterator {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        MapIterator() {
        }

        int nextEntry(int index) {
            while (index < Int2IntOpenHashTable.this._keys.length && Int2IntOpenHashTable.this._states[index] != 1) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < Int2IntOpenHashTable.this._keys.length;
        }

        @Override
        public int next() {
            int curEntry;
            if (!this.hasNext()) {
                return -1;
            }
            this.lastEntry = curEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(curEntry + 1);
            return curEntry;
        }

        @Override
        public int getKey() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Int2IntOpenHashTable.this._keys[this.lastEntry];
        }

        @Override
        public int getValue() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Int2IntOpenHashTable.this._values[this.lastEntry];
        }
    }

    public static interface IMapIterator {
        public boolean hasNext();

        public int next();

        public int getKey();

        public int getValue();
    }
}

