/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import java.io.Serializable;

public final class DoubleArrayList
implements Serializable {
    private static final long serialVersionUID = -8155789759545975413L;
    public static final int DEFAULT_CAPACITY = 12;
    private double[] data;
    private int used;

    public DoubleArrayList() {
        this(12);
    }

    public DoubleArrayList(int size) {
        this.data = new double[size];
        this.used = 0;
    }

    public DoubleArrayList(double[] initValues) {
        this.data = initValues;
        this.used = initValues.length;
    }

    public void add(double value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
    }

    public void add(double[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
    }

    private void expand(int max) {
        while (this.data.length < max) {
            int len = this.data.length;
            double[] newArray = new double[len * 2];
            System.arraycopy(this.data, 0, newArray, 0, len);
            this.data = newArray;
        }
    }

    public double remove() {
        return this.data[--this.used];
    }

    public double remove(int index) {
        double ret;
        if (index > this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[--this.used];
        } else {
            ret = this.data[index];
            double[] newarray = new double[--this.used];
            System.arraycopy(this.data, 0, newarray, 0, index - 1);
            System.arraycopy(this.data, index + 1, newarray, index, this.used - index);
            this.data = newarray;
        }
        return ret;
    }

    public void set(int index, double value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index MUST be less than \"size()\".");
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public double get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public double fastGet(int index) {
        return this.data[index];
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    public double[] toArray() {
        double[] newArray = new double[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        return newArray;
    }

    public double[] array() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

