/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import java.util.Comparator;
import java.util.PriorityQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BoundedPriorityQueue<E> {
    @Nonnegative
    private final int maxSize;
    @Nonnull
    private final Comparator<E> comparator;
    @Nonnull
    private final PriorityQueue<E> queue;

    public BoundedPriorityQueue(int size, @Nonnull Comparator<E> comparator) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal queue size: " + size);
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator should not be null");
        }
        this.maxSize = size;
        this.comparator = comparator;
        this.queue = new PriorityQueue<E>(size + 10, comparator);
    }

    public boolean offer(@Nonnull E e) {
        if (e == null) {
            throw new IllegalArgumentException("Null argument is not permitted");
        }
        int numElem = this.queue.size();
        if (numElem >= this.maxSize) {
            E smallest = this.queue.peek();
            int cmp = this.comparator.compare(e, smallest);
            if (cmp < 0) {
                return false;
            }
            this.queue.poll();
        }
        this.queue.offer(e);
        return true;
    }

    @Nullable
    public E poll() {
        return this.queue.poll();
    }

    @Nullable
    public E peek() {
        return this.queue.peek();
    }

    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }
}

